/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request.metrics;

import com.google.common.base.Preconditions;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.index.findings.calculation.NonCodeBinarySizeElementFindingsRetriever;
import com.teamscale.index.metrics.assessment.context.PartitionUpdateType;
import com.teamscale.service.merge_request.metrics.DeltaEntry;
import com.teamscale.service.merge_request.metrics.EChangeType;
import com.teamscale.service.merge_request.metrics.EMetricTrendColor;
import com.teamscale.service.merge_request.metrics.MergeRequestSingleMetricDetailsBinarySizeUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class MergeRequestSingleMetricDetailsUtils {
    public static UnmodifiableMap<String, DeltaEntry> computeDeltasByUniformPath(List<MetricDirectoryEntry> startEntries, List<MetricDirectoryEntry> endEntries, Map<String, NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent> startPathToContent, Map<String, NonCodeBinarySizeElementFindingsRetriever.NonCodeLinkContent> endPathToContent, int metricSchemaIndex, MetricDirectorySchema schema, boolean hideRefactoredEntries, boolean filterUnchangedEntries, boolean keepDeletedEntries, PartitionUpdateType partitionUpdateType) throws IllegalArgumentException {
        DeltaComputation deltaComputation = new DeltaComputation(schema, metricSchemaIndex, keepDeletedEntries, filterUnchangedEntries);
        HashMap<String, DeltaEntry> deltasByUniformPath = CollectionUtils.merge(MergeRequestSingleMetricDetailsUtils.getDoubleValuesByPath(startEntries, metricSchemaIndex), MergeRequestSingleMetricDetailsUtils.getDoubleValuesByPath(endEntries, metricSchemaIndex), deltaComputation::computeDelta);
        if (partitionUpdateType == PartitionUpdateType.BASELINE_INCOMPLETE) {
            HashMap<String, DeltaEntry> correctedMap = new HashMap<String, DeltaEntry>(deltasByUniformPath);
            for (Map.Entry entry : deltasByUniformPath.entrySet()) {
                correctedMap.put((String)entry.getKey(), ((DeltaEntry)entry.getValue()).unchangedAtEnd());
            }
            deltasByUniformPath = correctedMap;
        }
        if (hideRefactoredEntries) {
            MergeRequestSingleMetricDetailsBinarySizeUtils.transformDeltasForRefactorings((Map<String, DeltaEntry>)deltasByUniformPath, startEntries, endEntries, startPathToContent, endPathToContent, metricSchemaIndex, filterUnchangedEntries);
        }
        return CollectionUtils.asUnmodifiable((Map)deltasByUniformPath);
    }

    @Contract(value="null -> null; !null -> !null")
    public static @Nullable Double castToDouble(@Nullable Object value) throws IllegalArgumentException {
        if (value == null) {
            return null;
        }
        try {
            return ((Number)value).doubleValue();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Single metric details are currently only supported for scalar metrics.", e);
        }
    }

    static Map<String, @NonNull Double> getDoubleValuesByPath(List<MetricDirectoryEntry> entries, int metricIndex) throws IllegalArgumentException {
        HashMap<String, @NonNull Double> values = new HashMap<String, Double>();
        for (MetricDirectoryEntry entry : entries) {
            Double value = MergeRequestSingleMetricDetailsUtils.getAsNullableDouble(entry, metricIndex);
            if (value == null) continue;
            values.put(entry.getUniformPath(), value);
        }
        return values;
    }

    public static @NonNull Double getAsDouble(MetricDirectoryEntry entry, int metricIndex, MetricDirectorySchema schema) throws IllegalArgumentException {
        Double value = MergeRequestSingleMetricDetailsUtils.castToDouble(entry.getValueOrDefault(metricIndex, (Object)MergeRequestSingleMetricDetailsUtils.getDefaultValue(schema, metricIndex)));
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Value at index '%s' was null for entry '%s'.", (int)metricIndex, (Object)entry.getUniformPath());
        return value;
    }

    private static @Nullable Double getAsNullableDouble(MetricDirectoryEntry entry, int metricIndex) throws IllegalArgumentException {
        return MergeRequestSingleMetricDetailsUtils.castToDouble(entry.getValueWithoutNullAssert(metricIndex));
    }

    public static boolean isZero(double value) {
        return Math.abs(value) < 1.0E-10;
    }

    public static double getDefaultValue(MetricDirectorySchema schema, int metricIndex) throws IllegalArgumentException {
        Double defaultValue = MergeRequestSingleMetricDetailsUtils.castToDouble(schema.getEntry(metricIndex).getValueType().getDefaultValue());
        CCSMAssert.isFalse((defaultValue == null ? 1 : 0) != 0, (String)"Default value should not be null.");
        return defaultValue;
    }

    public static @Nullable EMetricTrendColor determineTrendColor(DeltaEntry deltaEntry, MetricDirectorySchema schema, int metricIndex) {
        boolean lowIsBad = schema.getEntry(metricIndex).getProperties().contains(EMetricProperty.LOW_IS_BAD);
        double delta = deltaEntry.delta();
        if (lowIsBad) {
            if (delta < 0.0) {
                return EMetricTrendColor.NEGATIVE;
            }
            if (delta > 0.0) {
                return EMetricTrendColor.POSITIVE;
            }
        } else {
            if (delta < 0.0) {
                return EMetricTrendColor.POSITIVE;
            }
            if (delta > 0.0) {
                return EMetricTrendColor.NEGATIVE;
            }
        }
        return null;
    }

    public static Set<String> getLeafPaths(List<MetricDirectoryEntry> startEntries, List<MetricDirectoryEntry> endEntries) {
        HashSet<String> uniformPaths = new HashSet<String>();
        startEntries.stream().filter(Predicate.not(MetricDirectoryEntry::hasChildren)).map(MetricDirectoryEntry::getUniformPath).forEach(uniformPaths::add);
        endEntries.stream().filter(Predicate.not(MetricDirectoryEntry::hasChildren)).map(MetricDirectoryEntry::getUniformPath).forEach(uniformPaths::add);
        return uniformPaths;
    }

    private MergeRequestSingleMetricDetailsUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    private static class DeltaComputation {
        private final double defaultValue;
        private final boolean keepDeletedEntries;
        private final boolean filterUnchangedEntries;

        private DeltaComputation(MetricDirectorySchema schema, int metricIndex, boolean keepDeletedEntries, boolean filterUnchangedEntries) {
            this.defaultValue = MergeRequestSingleMetricDetailsUtils.getDefaultValue(schema, metricIndex);
            this.keepDeletedEntries = keepDeletedEntries;
            this.filterUnchangedEntries = filterUnchangedEntries;
        }

        private DeltaEntry computeDelta(@Nullable Double startValue, @Nullable Double endValue) {
            CCSMAssert.isTrue((startValue != null || endValue != null ? 1 : 0) != 0, (String)"Expected %s or %s to be not null.".formatted("startValue", "endValue"));
            double endValueOrDefault = Objects.requireNonNullElse(endValue, this.defaultValue);
            double startValueOrDefault = Objects.requireNonNullElse(startValue, this.defaultValue);
            double diff = endValueOrDefault - startValueOrDefault;
            EChangeType change = EChangeType.determineChangeType(startValue, endValue, diff);
            if (!this.keepDeletedEntries && change == EChangeType.DELETE) {
                return null;
            }
            if (this.filterUnchangedEntries && change == EChangeType.UNCHANGED) {
                return null;
            }
            return new DeltaEntry(diff, startValueOrDefault, endValueOrDefault, change);
        }
    }
}

