/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.treemap;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.merge_request.BranchPointNotFoundException;
import com.teamscale.index.resource.TimeIntervalBasedServiceQueryOptions;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.query.ITgaCoverageSourceParameter;
import com.teamscale.index.testgap.query.ITgaRequest;
import com.teamscale.index.testgap.query.TgaCoverageSourceQueryParameters;
import com.teamscale.index.testgap.query.TgaRequestQueryOptions;
import com.teamscale.index.testgap.treemap.CoverageOverlapMethodTreeMapNode;
import com.teamscale.index.testgap.treemap.MethodTreeMapNodeBase;
import com.teamscale.index.testgap.treemap.TreeMapNodeBase;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.metrics.treemap.AbapTreemapUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/coverage/overlap-treemap")
public class CoverageOverlapTreeMapService
extends ApiBase {
    @GET
    @Cache(maxAge=5, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    @Operation(summary="Get coverage overlay treemap", description="Retrieves a coverage overlay treemap. For each method in the project, the treemap shows whether a method is covered by the partitions in set 1, set 2 or both.", tags={"Test Coverage"}, responses={@ApiResponse(responseCode="400", description="Could not find actual commit for given branch at given timestamp.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public CoverageOverlapTreeMapWrapper getCoverageOverlapTreeMap(@QueryParam(value="uniform-path") UniformPath uniformPath, @QueryParam(value="partitions1") List<String> partitions1, @QueryParam(value="all-partitions1") boolean allPartitions1, @QueryParam(value="partitions2") List<String> partitions2, @QueryParam(value="all-partitions2") boolean allPartitions2, @BeanParam TimeIntervalBasedServiceQueryOptions timeIntervalBasedParameters) throws StorageException, RepositoryException, BranchPointNotFoundException {
        ITgaRequest request1 = ITgaRequest.createRequest((ITgaCoverageSourceParameter)new TgaCoverageSourceQueryParameters(List.of(), partitions1, allPartitions1), (TimeIntervalBasedServiceQueryOptions)timeIntervalBasedParameters, (TgaRequestQueryOptions)new TgaRequestQueryOptions(false, null, false, uniformPath, null), null, (ETgaAssessmentType)ETgaAssessmentType.EXECUTION_ONLY, (IndexLayer)this.getIndexLayer(), (IProjectId)this.serviceInfo.getPrimaryPublicId(), (User)this.getUser());
        ITgaRequest request2 = ITgaRequest.createRequest((ITgaCoverageSourceParameter)new TgaCoverageSourceQueryParameters(List.of(), partitions2, allPartitions2), (TimeIntervalBasedServiceQueryOptions)timeIntervalBasedParameters, (TgaRequestQueryOptions)new TgaRequestQueryOptions(false, null, false, uniformPath, null), null, (ETgaAssessmentType)ETgaAssessmentType.EXECUTION_ONLY, (IndexLayer)this.getIndexLayer(), (IProjectId)this.serviceInfo.getPrimaryPublicId(), (User)this.getUser());
        AssessedTgaData assessedData1 = request1.fetchAndAssessData();
        AssessedTgaData assessedData2 = request2.fetchAndAssessData();
        return CoverageOverlapTreeMapService.createCoverageOverlapTreeMap(assessedData1.getMethods(), uniformPath, CoverageOverlapTreeMapService.buildIsExecutedLookup(assessedData1), CoverageOverlapTreeMapService.buildIsExecutedLookup(assessedData2));
    }

    private static Predicate<MethodLocation> buildIsExecutedLookup(AssessedTgaData assessedTestGapData) {
        List methods = assessedTestGapData.getMethods();
        Set executedMethods = methods.stream().filter(assessedMethodData -> assessedMethodData.getTestGapState() == ETestGapState.EXECUTED).map(AssessedTgaData.AssessedMethodData::getLocation).collect(Collectors.toSet());
        return executedMethods::contains;
    }

    private static CoverageOverlapTreeMapWrapper createCoverageOverlapTreeMap(List<AssessedTgaData.AssessedMethodData> methods, UniformPath rootUniformPath, Predicate<MethodLocation> lookup1, Predicate<MethodLocation> lookup2) {
        CoverageOverlapMethodTreeMapNode rootNode = CoverageOverlapTreeMapService.buildTreeMapNodes(methods, rootUniformPath, lookup1, lookup2);
        rootNode.recalculateAreaAggregates();
        AbapTreemapUtils.scaleAbapBwNodes((MethodTreeMapNodeBase)rootNode);
        rootNode.aggregateValues();
        return new CoverageOverlapTreeMapWrapper(rootNode);
    }

    private static CoverageOverlapMethodTreeMapNode buildTreeMapNodes(List<AssessedTgaData.AssessedMethodData> methods, UniformPath rootUniformPath, Predicate<MethodLocation> lookup1, Predicate<MethodLocation> lookup2) {
        CoverageOverlapMethodTreeMapNode root = new CoverageOverlapMethodTreeMapNode();
        List sortedMethods = CollectionUtils.sort(methods, Comparator.comparing(AssessedTgaData.AssessedMethodData::getLocation));
        for (AssessedTgaData.AssessedMethodData method : sortedMethods) {
            CoverageOverlapMethodTreeMapNode fileNode = CoverageOverlapMethodTreeMapNode.findOrCreateNode((CoverageOverlapMethodTreeMapNode)root, (UniformPath)method.getLocation().getUniformPath());
            fileNode.addChild((TreeMapNodeBase)new CoverageOverlapMethodTreeMapNode(method.getLocation().getUniformPath().toStringAsMigrationFrontier(), method.getLocation().getRegion(), method.getMethodName(), CoverageOverlapTreeMapService.getCoveredInPartitions(method, lookup1, lookup2)));
        }
        return CoverageOverlapMethodTreeMapNode.findOrCreateNode((CoverageOverlapMethodTreeMapNode)root, (UniformPath)rootUniformPath);
    }

    private static CoverageOverlapMethodTreeMapNode.EOverlapState getCoveredInPartitions(AssessedTgaData.AssessedMethodData method, Predicate<MethodLocation> lookup1, Predicate<MethodLocation> lookup2) {
        boolean containedIn1 = lookup1.test(method.getLocation());
        boolean containedIn2 = lookup2.test(method.getLocation());
        if (containedIn1 && containedIn2) {
            return CoverageOverlapMethodTreeMapNode.EOverlapState.BOTH;
        }
        if (containedIn1) {
            return CoverageOverlapMethodTreeMapNode.EOverlapState.SET_ONE;
        }
        if (containedIn2) {
            return CoverageOverlapMethodTreeMapNode.EOverlapState.SET_TWO;
        }
        return CoverageOverlapMethodTreeMapNode.EOverlapState.NONE;
    }

    public static class CoverageOverlapTreeMapWrapper {
        private static final String TREEMAP_PROPERTY = "treemap";
        @JsonProperty(value="treemap")
        private final CoverageOverlapMethodTreeMapNode treemap;

        @JsonCreator
        public CoverageOverlapTreeMapWrapper(@JsonProperty(value="treemap") CoverageOverlapMethodTreeMapNode treemap) {
            this.treemap = treemap;
        }

        public MethodTreeMapNodeBase getTreemap() {
            return this.treemap;
        }
    }
}

