/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.option;

import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.OptionDescriptor;
import com.teamscale.core.option.OptionIndexBase;
import com.teamscale.core.option.OptionRegistryBase;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.option.server.ServerOptionRegistry;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.option.OptionServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/options/server")
public class ServerOptionService
extends OptionServiceBase {
    private static final Set<String> PUBLIC_READ_OPTION_NAMES = CollectionUtils.asHashSet((Object[])new String[]{"ts.blacklisting-option", "enforce-global-default-storage", "default-external-storage-backend"});

    @GET
    @Path(value="schema")
    @Operation(summary="Get schema", description="Retrieves server option schema.", tags={"Administration"})
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_SERVER_OPTIONS})
    public List<OptionDescriptor> getServerOptionSchema() {
        return ServerOptionRegistry.getInstance().getOptionDescriptors();
    }

    @GET
    @Operation(summary="Get options", description="Retrieves all available server options.", tags={"Administration"})
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_SERVER_OPTIONS})
    public Map<String, IOption> getServerOptions() throws StorageException {
        ServerOptionIndex serverOptionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        return ServerOptionRegistry.getInstance().getOptions("server", (OptionIndexBase)serverOptionIndex);
    }

    @PUT
    @Operation(summary="Edit options", description="Edits multiple server options at once", responses={@ApiResponse(responseCode="404", description="No descriptor for one or more options found."), @ApiResponse(responseCode="400", description="Could not parse one or more options.")}, tags={"Administration"})
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_SERVER_OPTIONS})
    public void editServerOptions(@Parameter(description="If options should be saved despite failing validation") @QueryParam(value="save-if-validation-fails") boolean saveIfValidationFails, @RequestBody(description="Map of option IDs to option values as JSON", required=true) Map<String, Object> optionsBatch) throws StorageException {
        ServerOptionIndex serverOptionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        this.editOptions((OptionRegistryBase)ServerOptionRegistry.getInstance(), optionsBatch, "server", saveIfValidationFails, (OptionIndexBase)serverOptionIndex);
        AuditLogs.editServerOptions();
    }

    @GET
    @Operation(summary="Get option", description="Retrieves the server option identified by the given name.", responses={@ApiResponse(responseCode="404", description="Unknown option name provided")}, tags={"Administration"})
    @RequiresNoPermission(description="EDIT_SERVER_OPTIONS permission needed for most options, but some options (PUBLIC_READ_OPTION_NAMES) can be read without permission")
    @Path(value="{optionId}")
    public IOption getSingleServerOption(@Parameter(description="Name of the option to retrieve.") @PathParam(value="optionId") String optionId) throws StorageException {
        if (!PUBLIC_READ_OPTION_NAMES.contains(optionId)) {
            this.getPermissions().checkGlobalPermission(EGlobalPermission.EDIT_SERVER_OPTIONS);
        }
        ServerOptionIndex serverOptionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        return this.getSingleOption("server", optionId, (OptionIndexBase)serverOptionIndex, (OptionRegistryBase)ServerOptionRegistry.getInstance());
    }

    @PUT
    @Operation(summary="Edit option", description="Edits the specified server option", responses={@ApiResponse(responseCode="404", description="No descriptor for option found."), @ApiResponse(responseCode="400", description="Could not parse the given option.")}, tags={"Administration"})
    @Path(value="{optionId}")
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_SERVER_OPTIONS})
    public void editServerOption(@Parameter(description="Name of the option to edit") @PathParam(value="optionId") String optionId, @Parameter(description="If the option should be saved despite failing validation") @QueryParam(value="save-if-validation-fails") boolean saveIfValidationFails, @RequestBody(description="List of objects represented as JSON", required=true, content={@Content(mediaType="application/json", schema=@Schema(implementation=Object.class))}) byte[] optionJson) throws StorageException {
        ServerOptionIndex serverOptionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        this.editOption((OptionRegistryBase)ServerOptionRegistry.getInstance(), optionJson, "server", optionId, saveIfValidationFails, (OptionIndexBase)serverOptionIndex);
        AuditLogs.editServerOptions();
    }

    @DELETE
    @Operation(summary="Delete option", description="Deletes the specified server option", tags={"Administration"})
    @Path(value="{optionId}")
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_SERVER_OPTIONS})
    public void deleteServerOption(@Parameter(description="Name of the option to delete") @PathParam(value="optionId") String optionId) throws StorageException {
        ServerOptionIndex serverOptionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        this.deleteOption((OptionRegistryBase)ServerOptionRegistry.getInstance(), "server", optionId, (OptionIndexBase)serverOptionIndex);
        AuditLogs.deletedServerOption((String)optionId);
    }
}

