/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.plsql.debug;

import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.testgap.SourceLocation;
import com.teamscale.index.testgap.plsql.HProfMethodMappingIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/projects/{project}/plsql/debug/mappings")
public class DebugPlSqlPackageMappingService
extends ApiBase {
    @GET
    @Operation(summary="Download PL/SQL package mappings", description="Downloads mappings mappings from PL/SQL packages to files. In order for the data to be available, the PL/SQL Hierarchical Profiler must be enabled in the analysis profile.", tags={"Debugging"}, responses={@ApiResponse(responseCode="400", description="Download failed. PL/SQL Hierarchical Profiler analysis is not enabled.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Produces(value={"text/csv"})
    public String downloadPlSqlPackageMappings(@QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor unresolvedCommitDescriptor) throws StorageException {
        this.checkIfHProfIsEnabled();
        HProfMethodMappingIndex mappingIndex = this.openProjectIndex(HProfMethodMappingIndex.class, this.determineHistoryOption(unresolvedCommitDescriptor));
        PairList mappings = mappingIndex.getAllSourceLocations();
        return "Package;Uniform Path" + StringUtils.LINE_SEPARATOR + mappings.stream().map(pair -> StringUtils.removeLastPart((String)((String)pair.getFirst()), (char)'.') + ";" + ((SourceLocation)pair.getSecond()).getUniformPath()).sorted().distinct().collect(Collectors.joining(StringUtils.LINE_SEPARATOR));
    }

    private void checkIfHProfIsEnabled() throws StorageException {
        MetaIndex projectMetaIndex = (MetaIndex)this.getProjectStorageSystem().openProjectIndex(MetaIndex.class, null);
        if (!AnalysisProfileUtils.getConfiguredTools((MetaIndex)projectMetaIndex).contains(EAnalysisTool.PLSQL_HPROF)) {
            throw new BadRequestException("Download failed. " + EAnalysisTool.PLSQL_HPROF.getReadableName() + " analysis is not enabled in the analysis configuration for project: " + String.valueOf(this.serviceInfo.getPrimaryPublicId()) + ".");
        }
    }
}

