/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project.analysis_profile;

import com.teamscale.core.analysis.configuration.ConfigRegistry;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.NamedConfigurableObjectBase;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.QualityIndicatorTemplate;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.configuration.AnalysisProfileVersionedIndex;
import com.teamscale.index.configuration.ProjectValidationUtils;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.NonNull;

public final class AnalysisProfileImportUtils {
    public static ConfigurationTemplate createConfigurationTemplate(EAnalysisTool analysisTool, Set<ELanguage> languages, boolean enableTeamscaleDefaults, Map<String, String> groupToQualityIndicatorMapping, GlobalStorageSystem globalStorageSystem) throws ProjectConfigurationException {
        ConfigurationTemplate template = ConfigRegistry.getInstance().createConfigurationTemplate(languages, Set.of(analysisTool), globalStorageSystem);
        for (Map.Entry<String, String> groupAndIndicator : groupToQualityIndicatorMapping.entrySet()) {
            QualityIndicatorTemplate qualityIndicator = template.getOrCreateQualityIndicatorTemplate(groupAndIndicator.getValue());
            if (qualityIndicator.getGroupNames().contains((Object)groupAndIndicator.getKey()) || template.getAnalysisGroup(groupAndIndicator.getKey()) == null) continue;
            qualityIndicator.addGroup(template.getAnalysisGroup(groupAndIndicator.getKey()));
        }
        if (!enableTeamscaleDefaults) {
            AnalysisProfileImportUtils.removeUnusedAnalysisGroups(groupToQualityIndicatorMapping, template);
        }
        return template;
    }

    private static void removeUnusedAnalysisGroups(Map<String, String> groupToQualityIndicatorMapping, ConfigurationTemplate template) {
        for (QualityIndicatorTemplate qualityIndicatorTemplate : template.getQualityIndicators()) {
            HashSet<String> groupsToRemove = new HashSet<String>();
            for (String analysisGroupName : qualityIndicatorTemplate.getGroupNames()) {
                if (groupToQualityIndicatorMapping.containsKey(analysisGroupName)) continue;
                groupsToRemove.add(analysisGroupName);
            }
            qualityIndicatorTemplate.removeGroups(groupsToRemove);
        }
    }

    public static @NonNull Map<String, AnalysisGroup> getAnalysisGroupsByName(AnalysisProfile analysisProfile) {
        return analysisProfile.getQualityIndicators().stream().flatMap(indicator -> indicator.getGroups().stream()).collect(Collectors.toMap(NamedConfigurableObjectBase::getName, Function.identity()));
    }

    public static void writeProfile(AnalysisProfile analysisProfile, IndexLayer indexLayer, ServicePermissions permissions) throws StorageException {
        ProjectValidationUtils.validateAnalysisProfile((AnalysisProfile)analysisProfile, (GlobalStorageSystem)indexLayer.openGlobalStorageSystem(), (boolean)true);
        AnalysisProfileIndex profileIndex = (AnalysisProfileIndex)indexLayer.openGlobalIndex(AnalysisProfileIndex.class);
        AnalysisProfileVersionedIndex versionedIndex = (AnalysisProfileVersionedIndex)indexLayer.openGlobalIndex(AnalysisProfileVersionedIndex.class);
        AnalysisProfileUtils.updateCurrentProfileSilently((AnalysisProfileVersionedIndex)versionedIndex, (AnalysisProfileIndex)profileIndex, (AnalysisProfile)analysisProfile);
        permissions.createPermissionModifier().makeCurrentUserOwner(EBasicPermissionScope.ANALYSIS_PROFILES, analysisProfile.getName());
    }

    public static void disableAllChecksExcept(Collection<AnalysisGroup> analysisGroups, Set<String> checksToKeep, ConfigurationTemplate configurationTemplate) {
        Set allFindings = configurationTemplate.getAnalysisGroups().stream().flatMap(groupDescriptor -> groupDescriptor.getConfigurationItems().stream().filter(item -> item instanceof FindingDescriptor).map(ConfigurationItemBase::getName)).collect(Collectors.toSet());
        for (AnalysisGroup analysisGroup : analysisGroups) {
            for (String option : analysisGroup.getOptionNames()) {
                if (!allFindings.contains(option) || checksToKeep.contains(option)) continue;
                analysisGroup.setOptionValue(option, EFindingEnablement.OFF.toString());
            }
        }
    }

    private AnalysisProfileImportUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

