/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project.analysis_profile;

import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.index.model.QualityIndicator;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/configuration/quality-indicators")
public class QualityIndicatorService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get quality indicator names", description="Returns the union of distinct quality indicator names configured in the analysis profiles of all code scopes of a project.")
    public Set<String> getQualityIndicators() throws StorageException {
        ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((IProjectId)this.serviceInfo.getPrimaryPublicId(), (IndexLayer)this.getIndexLayer());
        List qualityIndicators = AnalysisProfileUtils.getConfiguredQualityIndicators((IndexLayer)this.getIndexLayer(), (ProjectConfiguration)projectConfiguration);
        return qualityIndicators.stream().map(QualityIndicator::getName).collect(Collectors.toSet());
    }
}

