/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.FormattedTokenElementInfo;
import com.teamscale.index.resource.KubernetesManifestIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Set;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/kubernetes-manifest/{uniformPath: .*}")
public class KubernetesManifestService
extends ApiBase {
    @GET
    @Operation(summary="Get full Kubernetes manifest", description="Returns the content of the full Kubernetes manifest which is built from the given Helm chart or Kustomization. Returns null in case no full manifest is available for the given uniform path, e.g. a non-root Kustomization.", tags={"Source Code"}, responses={@ApiResponse(responseCode="204", description="The uniform path is not available.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public @Nullable FormattedTokenElementInfo getKubernetesManifest(@PathParam(value="uniformPath") String uniformPath, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        KubernetesManifestIndex kubernetesManifestIndex = this.openProjectIndex(KubernetesManifestIndex.class, historyAccessOption);
        TokenElementInfo value = kubernetesManifestIndex.getKubernetesManifest(uniformPath);
        if (value == null) {
            return null;
        }
        return new FormattedTokenElementInfo(value, (Set)CollectionUtils.emptySet());
    }
}

