/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.ContainerInfo;
import com.teamscale.index.resource.resolution_strategy.IResourceResolutionStrategy;
import com.teamscale.index.resource.resolution_strategy.ResourceResolutionStrategyFactory;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/directory")
@Cache(maxAge=1)
public class ResourceInfoService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Operation(summary="Get the resource/directory information", description="Retrieves the resource/directory information for a resource or a resource sub-tree.", tags={"Project"}, responses={@ApiResponse(responseCode="404", description="The resource for the given uniform path could not be found.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public ContainerInfo getResourceInfo(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Uniform path to retrieve the resource/directory information for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath) throws StorageException {
        IResourceResolutionStrategy resourceResolutionStrategy = ResourceResolutionStrategyFactory.getStrategy((UniformPath)uniformPath, (ProjectStorageSystem)this.getProjectStorageSystem());
        ContainerInfo container = resourceResolutionStrategy.getContainerInfoForPath(uniformPath, this.determineHistoryOption(commit));
        if (container == null) {
            LOGGER.warn("The resource for the uniform path " + String.valueOf(uniformPath) + " could not be found.");
        }
        return container;
    }
}

