/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.health;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.index.system_info.EHealthCheckStatus;
import com.teamscale.index.system_info.ESystemHealthCheck;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.system.health.SystemHealthUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/health-check")
public class SystemHealthCheckService
extends ApiBase {
    @GET
    @PublicApi(since=ETeamscaleVersion.VERSION_5_5_0)
    @RequiresNoLogin(description="No login required to perform monitoring.")
    @Operation(summary="Get system health status", description="Retrieves a log of system health status information.", tags={"Monitoring"}, responses={@ApiResponse(responseCode="400", description="Unknown system health check(s) requested.")})
    public String getHealthStatus(@Parameter(description="List of system health checks to perform") @QueryParam(value="check") List<String> checkParameters, @Parameter(description="Determines if only critical health check entries should be returned") @QueryParam(value="critical-only") boolean criticalOnly) throws StorageException {
        StringBuilder resultBuilder = new StringBuilder();
        List<ESystemHealthCheck> checks = SystemHealthUtils.determineChecksOrMetrics(checkParameters, ESystemHealthCheck.class);
        EHealthCheckStatus worst = EHealthCheckStatus.OK;
        for (ESystemHealthCheck check : checks) {
            ESystemHealthCheck.CheckResult result = check.performCheck(this.serviceInfo.getIndexLayer());
            EHealthCheckStatus status = result.status();
            if (criticalOnly && status.ordinal() < EHealthCheckStatus.CRITICAL.ordinal()) continue;
            resultBuilder.append(check.getReadableName()).append(" ").append(status.getReadableName()).append(": ").append(result.message()).append("\n");
            if (status.ordinal() <= worst.ordinal()) continue;
            worst = status;
        }
        String summary = "Status summary: " + String.valueOf(worst) + " (RC: " + worst.ordinal() + ")\n";
        return summary + String.valueOf(resultBuilder);
    }
}

