/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.scheduler.debug;

import com.teamscale.core.committree.ECommitTreeNodeState;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.runtime.impl.rollback.RollbackLogIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Date;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/scheduler/debug/rollback-log.csv")
public class DebugRollbackLogService
extends ApiBase {
    private static final String SEPARATOR = ";";

    @GET
    @Operation(summary="Get rollback log as CSV", description="Returns rollback information as a CSV file.", tags={"Debugging"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/plain"})
    public String getRollbackLogAsCsv() throws StorageException {
        StringBuilder builder = new StringBuilder();
        DebugRollbackLogService.appendHeader(builder);
        for (RollbackLogIndex.RollbackLogEntry entry : this.openProjectIndex(RollbackLogIndex.class, null).getAllEntries()) {
            DebugRollbackLogService.appendEntry(builder, entry);
        }
        return builder.toString();
    }

    private static void appendHeader(StringBuilder builder) {
        builder.append("timestamp of execution");
        builder.append(SEPARATOR).append("rollback ID");
        builder.append(SEPARATOR).append("formatted timestamp of execution");
        builder.append(SEPARATOR).append("execution time of rollback (sec)");
        builder.append(SEPARATOR).append("minimal rollback timestamp");
        builder.append(SEPARATOR).append("formatted minimal rollback timestamp");
        builder.append(SEPARATOR).append("precommit rollback");
        for (ECommitTreeNodeState state : ECommitTreeNodeState.values()) {
            builder.append(SEPARATOR).append("Rolled back commits in state ").append(state);
        }
        builder.append(SEPARATOR).append("affected branch count");
        builder.append(SEPARATOR).append("affected branches");
        builder.append("\n");
    }

    private static void appendEntry(StringBuilder builder, RollbackLogIndex.RollbackLogEntry entry) {
        builder.append(entry.getTimestamp());
        builder.append(SEPARATOR).append(entry.getRollbackId());
        builder.append(SEPARATOR).append(new Date(entry.getTimestamp()));
        builder.append(SEPARATOR).append(entry.getExecutionTimeSeconds());
        builder.append(SEPARATOR).append(entry.getMinimalTimestamp());
        builder.append(SEPARATOR).append(new Date(entry.getMinimalTimestamp()));
        builder.append(SEPARATOR).append(entry.isPrecommitRollback());
        for (ECommitTreeNodeState state : ECommitTreeNodeState.values()) {
            builder.append(SEPARATOR).append(entry.getRolledBackStateCount().getValue((Object)state));
        }
        builder.append(SEPARATOR).append(entry.getAffectedBranchCount());
        entry.getAffectedBranches().forEach(branch -> builder.append(SEPARATOR).append((String)branch));
        builder.append("\n");
    }
}

