/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testimpact.prioritization.preprocessing;

import com.google.common.collect.Iterables;
import com.teamscale.index.testimpact.MethodId;
import com.teamscale.index.testimpact.MultipleParentUpdateStrategy;
import com.teamscale.service.testimpact.TestDataRetriever;
import com.teamscale.service.testimpact.prioritization.PrioritizableTest;
import com.teamscale.service.testimpact.prioritization.preprocessing.TestPrioritizationPreprocessingStepBase;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class LoadAllCoveredMethodsStep
extends TestPrioritizationPreprocessingStepBase {
    public LoadAllCoveredMethodsStep(TestDataRetriever dataRetriever) {
        super(dataRetriever);
    }

    @Override
    public void execute(Set<PrioritizableTest> tests) throws StorageException {
        Iterable partitions = Iterables.partition(tests, (int)MultipleParentUpdateStrategy.MAX_TEST_CHUNKS);
        for (List testListPartition : partitions) {
            Collection<Set<MethodId>> coveredMethodInfoKeysPerTest = this.dataRetriever.getCoveredMethodsPerTest(testListPartition);
            CollectionUtils.forEach((Iterable)testListPartition, coveredMethodInfoKeysPerTest, PrioritizableTest::setCoveredMethods);
        }
    }
}

