/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.treemap;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.teamscale.service.treemap.CoverageMethodTreeMapNode;
import com.teamscale.service.treemap.FindingsResolvedMethodTreeMapNode;
import com.teamscale.service.treemap.MethodBasedTreeMapNodeBase;
import jakarta.ws.rs.BadRequestException;
import java.lang.runtime.SwitchBootstraps;
import java.util.IntSummaryStatistics;
import java.util.Objects;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.jspecify.annotations.Nullable;

@ExportToTypeScript
public enum EStatisticsCalculation {
    AVERAGE_BASED((Function<StatisticsCalculationContext, IStatisticsCalculator>)((Function)ignored -> new AverageBaseStatisticsCalculator())),
    METHOD_BASED((Function<StatisticsCalculationContext, IStatisticsCalculator>)((Function)MethodBasedStatisticsCalculator::new)),
    AREA_BASED((Function<StatisticsCalculationContext, IStatisticsCalculator>)((Function)AreaBasedStatisticsCalculator::new));

    private final Function<StatisticsCalculationContext, IStatisticsCalculator> calculatorFactory;

    private EStatisticsCalculation(Function<StatisticsCalculationContext, IStatisticsCalculator> calculatorFactory) {
        this.calculatorFactory = calculatorFactory;
    }

    IStatisticsCalculator createStatisticsCalculator(StatisticsCalculationContext context) {
        return (IStatisticsCalculator)this.calculatorFactory.apply((Object)context);
    }

    static interface IStatisticsCalculator {
        public void updateStatistics(MethodBasedTreeMapNodeBase var1);

        public double getAverage();
    }

    private static class AverageBaseStatisticsCalculator
    implements IStatisticsCalculator {
        private double dividend;
        private double divisor;

        private AverageBaseStatisticsCalculator() {
        }

        @Override
        public void updateStatistics(MethodBasedTreeMapNodeBase treeMapNode) {
            MethodBasedTreeMapNodeBase methodBasedTreeMapNodeBase = treeMapNode;
            Objects.requireNonNull(methodBasedTreeMapNodeBase);
            MethodBasedTreeMapNodeBase methodBasedTreeMapNodeBase2 = methodBasedTreeMapNodeBase;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FindingsResolvedMethodTreeMapNode.class, CoverageMethodTreeMapNode.class}, (Object)((Object)methodBasedTreeMapNodeBase2), n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    FindingsResolvedMethodTreeMapNode findingNode = (FindingsResolvedMethodTreeMapNode)methodBasedTreeMapNodeBase2;
                    this.dividend += (double)findingNode.getNumberOfFindings();
                    this.divisor += 1.0;
                    break;
                }
                case 1: {
                    CoverageMethodTreeMapNode coverageNode = (CoverageMethodTreeMapNode)methodBasedTreeMapNodeBase2;
                    this.dividend += (double)coverageNode.getCoveredLines();
                    this.divisor += (double)coverageNode.getCoverableLines();
                }
            }
        }

        @Override
        public double getAverage() {
            return this.dividend / this.divisor;
        }
    }

    private static class AreaBasedStatisticsCalculator
    implements IStatisticsCalculator {
        private final StatisticsCalculationContext context;
        private double affectedArea;
        private double wholeArea;

        public AreaBasedStatisticsCalculator(StatisticsCalculationContext context) {
            this.context = context;
        }

        @Override
        public void updateStatistics(MethodBasedTreeMapNodeBase treeMapNode) {
            boolean affected;
            this.wholeArea += treeMapNode.getArea();
            MethodBasedTreeMapNodeBase methodBasedTreeMapNodeBase = treeMapNode;
            Objects.requireNonNull(methodBasedTreeMapNodeBase);
            MethodBasedTreeMapNodeBase methodBasedTreeMapNodeBase2 = methodBasedTreeMapNodeBase;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FindingsResolvedMethodTreeMapNode.class, CoverageMethodTreeMapNode.class}, (Object)((Object)methodBasedTreeMapNodeBase2), n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    boolean bl;
                    FindingsResolvedMethodTreeMapNode findingNode = (FindingsResolvedMethodTreeMapNode)methodBasedTreeMapNodeBase2;
                    if (!findingNode.getFindings().isEmpty()) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 1: {
                    CoverageMethodTreeMapNode coverageNode = (CoverageMethodTreeMapNode)methodBasedTreeMapNodeBase2;
                    boolean bl = affected = coverageNode.getCoverage() < this.context.getCoverageViolationThreshold();
                }
            }
            if (affected) {
                this.affectedArea += treeMapNode.getArea();
            }
        }

        @Override
        public double getAverage() {
            if (this.wholeArea == 0.0) {
                return 0.0;
            }
            return this.affectedArea / this.wholeArea;
        }
    }

    private static class MethodBasedStatisticsCalculator
    implements IStatisticsCalculator {
        private final IntSummaryStatistics method = new IntSummaryStatistics();
        private final StatisticsCalculationContext context;

        public MethodBasedStatisticsCalculator(StatisticsCalculationContext context) {
            this.context = context;
        }

        @Override
        public void updateStatistics(MethodBasedTreeMapNodeBase treeMapNode) {
            boolean violatesThreshold;
            MethodBasedTreeMapNodeBase methodBasedTreeMapNodeBase = treeMapNode;
            Objects.requireNonNull(methodBasedTreeMapNodeBase);
            MethodBasedTreeMapNodeBase methodBasedTreeMapNodeBase2 = methodBasedTreeMapNodeBase;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FindingsResolvedMethodTreeMapNode.class, CoverageMethodTreeMapNode.class}, (Object)((Object)methodBasedTreeMapNodeBase2), n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    boolean bl;
                    FindingsResolvedMethodTreeMapNode findingNode = (FindingsResolvedMethodTreeMapNode)methodBasedTreeMapNodeBase2;
                    if (findingNode.getNumberOfFindings() > 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 1: {
                    CoverageMethodTreeMapNode coverageNode = (CoverageMethodTreeMapNode)methodBasedTreeMapNodeBase2;
                    boolean bl = violatesThreshold = coverageNode.getCoverage() < this.context.getCoverageViolationThreshold();
                }
            }
            if (violatesThreshold) {
                this.method.accept(1);
            } else {
                this.method.accept(0);
            }
        }

        @Override
        public double getAverage() {
            return this.method.getAverage();
        }
    }

    static class StatisticsCalculationContext {
        @JsonProperty(value="coverageViolationThreshold")
        private final @Nullable Double coverageViolationThreshold;

        @JsonCreator
        public StatisticsCalculationContext(@JsonProperty(value="coverageViolationThreshold") @Nullable Double coverageViolationThreshold) {
            this.coverageViolationThreshold = coverageViolationThreshold;
        }

        static StatisticsCalculationContext fromJson(JsonNode jsonNode) {
            try {
                return (StatisticsCalculationContext)JsonUtils.getObjectMapper().treeToValue((TreeNode)jsonNode, StatisticsCalculationContext.class);
            }
            catch (JsonProcessingException e) {
                throw new BadRequestException((Throwable)e);
            }
        }

        public double getCoverageViolationThreshold() {
            Preconditions.checkState((this.coverageViolationThreshold != null ? 1 : 0) != 0, (Object)"No coverage violation threshold specified");
            return this.coverageViolationThreshold;
        }
    }
}

