/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.usage;

import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.index.testgap.abap.UsageInfo;
import com.teamscale.index.usage.MethodUsageCountIndex;
import com.teamscale.service.base.ApiBase;
import jakarta.ws.rs.BadRequestException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;

public abstract class UsageServiceBase
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    protected List<UsageInfo> createRelevantUsageInfos(UniformPath uniformPath, CommitDescriptor baseline, CommitDescriptor end) throws StorageException {
        if (uniformPath.isArchitecturePath()) {
            throw new BadRequestException("Architecture paths are not supported yet.");
        }
        ArrayList<UsageInfo> usageInfos = new ArrayList<UsageInfo>();
        Map<String, Long> startCounts = this.getUsageCounts(uniformPath.toString(), baseline);
        Map<String, Long> endCounts = this.getUsageCounts(uniformPath.toString(), end);
        List<AssociatedMethodInfo> methodInfos = this.loadMethodInfos(uniformPath, end);
        for (AssociatedMethodInfo methodInfo : methodInfos) {
            long executions;
            String methodId = methodInfo.getKey();
            long endCount = endCounts.getOrDefault(methodId, 0L);
            long startCount = startCounts.getOrDefault(methodId, 0L);
            if (startCount < 0L) {
                LOGGER.error("Unexpected negative method usage count " + startCount + " at baseline commit " + String.valueOf(baseline) + " for method: " + String.valueOf(methodInfo));
            }
            if (endCount < 0L) {
                LOGGER.error("Unexpected negative method usage count " + endCount + " at end commit " + String.valueOf(end) + " for method: " + String.valueOf(methodInfo));
            }
            if ((executions = endCount - startCount) < 0L) {
                executions = Math.max(endCount, 0L);
            }
            usageInfos.add(new UsageInfo(methodInfo.getUniformPath().toStringAsMigrationFrontier(), methodInfo.getAssociatedRegion(), executions, methodInfo));
        }
        return usageInfos;
    }

    private List<AssociatedMethodInfo> loadMethodInfos(UniformPath uniformPath, CommitDescriptor end) throws StorageException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)end);
        MethodInfoIndex infoIndex = this.openProjectIndex(MethodInfoIndex.class, historyAccessOption);
        return infoIndex.getMethodInfosForPathPrefix(uniformPath);
    }

    private Map<String, Long> getUsageCounts(String uniformPath, CommitDescriptor commit) throws StorageException {
        MethodUsageCountIndex countIndex = this.openProjectIndex(MethodUsageCountIndex.class, HistoryAccessOption.readTimestamp((String)commit.getBranchName(), (long)commit.getTimestamp()));
        return countIndex.getMethodUsageCounts(uniformPath).toMap();
    }
}

