/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.webhook.github.event_handler;

import com.teamscale.core.authenticate.github.index.OAuthTokenIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.service.webhook.github.data.GitHubAppAuthorizationEventPayload;
import com.teamscale.service.webhook.github.event_handler.GitHubWebhookEventHandlerBase;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.intellij.lang.annotations.Language;

class GitHubAppAuthorizationEventHandler
extends GitHubWebhookEventHandlerBase {
    GitHubAppAuthorizationEventHandler(IndexLayer indexLayer) {
        super(indexLayer);
    }

    @Override
    public void handle(@Language(value="JSON") String eventPayload) throws StorageException, JsonSerializationException {
        GitHubAppAuthorizationEventPayload authPayload = (GitHubAppAuthorizationEventPayload)JsonUtils.deserializeFromJsonWithNullCheck((String)eventPayload, GitHubAppAuthorizationEventPayload.class);
        String userName = authPayload.sender().getLogin();
        OAuthTokenIndex oAuthTokenIndex = (OAuthTokenIndex)this.indexLayer.openGlobalIndex(OAuthTokenIndex.class);
        if ("revoked".equals(authPayload.action())) {
            oAuthTokenIndex.removeToken(userName.toLowerCase());
        }
    }
}

