/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.gc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import jetbrains.exodus.core.execution.JobProcessorAdapter;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.gc.BackgroundCleaner;
import jetbrains.exodus.gc.GarbageCollector;
import jetbrains.exodus.gc.GcJob;
import jetbrains.exodus.gc.UtilizationProfile;
import jetbrains.exodus.log.Log;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\b\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0014\u001a\u00020\tH\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0010H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/exodus/gc/BackgroundCleaningJob;", "Ljetbrains/exodus/gc/GcJob;", "gc", "Ljetbrains/exodus/gc/GarbageCollector;", "(Ljetbrains/exodus/gc/GarbageCollector;)V", "beforeGcActions", "Ljava/util/ArrayList;", "Ljava/lang/Runnable;", "addBeforeGcAction", "", "action", "canContinue", "", "cleanFiles", "fragmentedFiles", "", "", "doCleanLog", "log", "Ljetbrains/exodus/log/Log;", "doJob", "getName", "", "wakeAt", "time", "xodus-environment"})
public final class BackgroundCleaningJob
extends GcJob {
    @NotNull
    private final ArrayList<Runnable> beforeGcActions;

    public BackgroundCleaningJob(@NotNull GarbageCollector gc) {
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        super(gc, null, 2, null);
        this.beforeGcActions = new ArrayList();
    }

    @NotNull
    public String getName() {
        return "Background cleaner";
    }

    public final void addBeforeGcAction(@NotNull Runnable action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        ((Collection)this.beforeGcActions).add(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doJob() {
        long currentTime;
        GarbageCollector garbageCollector = this.getGc();
        if (garbageCollector == null) {
            return;
        }
        GarbageCollector gc = garbageCollector;
        BackgroundCleaner cleaner = gc.getCleaner$xodus_environment();
        if (!cleaner.isCurrentThread()) {
            JobProcessorAdapter processor = cleaner.getJobProcessor();
            GarbageCollector.Companion.loggingInfo$xodus_environment((Function0<String>)((Function0)new Function0<String>(gc, cleaner){
                final /* synthetic */ GarbageCollector $gc;
                final /* synthetic */ BackgroundCleaner $cleaner;
                {
                    this.$gc = $gc;
                    this.$cleaner = $cleaner;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Re-queueing BackgroundCleaningJob[" + this.$gc.getEnvironment$xodus_environment().getLocation() + "] to thread[" + this.$cleaner.getThreadId$xodus_environment() + ']';
                }
            }));
            this.reQueue(processor);
            return;
        }
        long minTimeToInvokeCleaner = gc.getStartTime$xodus_environment();
        if (minTimeToInvokeCleaner > (currentTime = System.currentTimeMillis())) {
            this.wakeAt(gc, minTimeToInvokeCleaner);
            return;
        }
        EnvironmentImpl env = gc.getEnvironment$xodus_environment();
        EnvironmentConfig environmentConfig = env.getEnvironmentConfig();
        Intrinsics.checkNotNullExpressionValue((Object)environmentConfig, (String)"env.environmentConfig");
        EnvironmentConfig ec = environmentConfig;
        int gcRunPeriod = ec.getGcRunPeriod();
        if (gcRunPeriod > 0 && gc.getLastInvocationTime() + (long)gcRunPeriod > currentTime) {
            this.wakeAt(gc, gc.getLastInvocationTime() + (long)gcRunPeriod);
            return;
        }
        Log log = env.getLog();
        Intrinsics.checkNotNullExpressionValue((Object)log, (String)"env.log");
        Log log2 = log;
        if ((long)gc.getMinFileAge$xodus_environment() < log2.getNumberOfFiles()) {
            if (!this.canContinue()) {
                this.wakeAt(gc, System.currentTimeMillis() + (long)gcRunPeriod);
                return;
            }
            cleaner.setCleaning(true);
            try {
                this.doCleanLog(log2, gc);
                if (gc.isTooMuchFreeSpace$xodus_environment() && gcRunPeriod > 0) {
                    this.wakeAt(gc, System.currentTimeMillis() + (long)gcRunPeriod);
                }
            }
            finally {
                gc.setLastInvocationTime(System.currentTimeMillis());
                cleaner.setCleaning(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doCleanLog(Log log, GarbageCollector gc) {
        GarbageCollector.Companion.loggingInfo$xodus_environment((Function0<String>)((Function0)new Function0<String>(log){
            final /* synthetic */ Log $log;
            {
                this.$log = $log;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return Intrinsics.stringPlus((String)"Executing before GC actions for ", (Object)this.$log.getLocation());
            }
        }));
        try {
            Iterable $this$forEach$iv = this.beforeGcActions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Runnable it = (Runnable)element$iv;
                boolean bl = false;
                it.run();
            }
        }
        catch (Throwable t) {
            GarbageCollector.Companion.loggingError$xodus_environment(t, (Function0<String>)((Function0)new Function0<String>(log){
                final /* synthetic */ Log $log;
                {
                    this.$log = $log;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return Intrinsics.stringPlus((String)"Failed to execute before GC actions for ", (Object)this.$log.getLocation());
                }
            }));
        }
        UtilizationProfile up = gc.getUtilizationProfile();
        GarbageCollector.Companion.loggingInfo$xodus_environment((Function0<String>)((Function0)new Function0<String>(log, up){
            final /* synthetic */ Log $log;
            final /* synthetic */ UtilizationProfile $up;
            {
                this.$log = $log;
                this.$up = $up;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Starting background cleaner loop for " + this.$log.getLocation() + ", free space: " + this.$up.totalFreeSpacePercent$xodus_environment() + '%';
            }
        }));
        EnvironmentImpl env = gc.getEnvironment$xodus_environment();
        long highFile = log.getHighFileAddress();
        long loopStart = System.currentTimeMillis();
        int gcRunPeriod = env.getEnvironmentConfig().getGcRunPeriod();
        try {
            Iterator<Long> fragmentedFiles;
            while ((fragmentedFiles = up.getFilesSortedByUtilization$xodus_environment(highFile)).hasNext()) {
                if (!this.cleanFiles(gc, fragmentedFiles)) {
                    Thread.yield();
                }
                if (this.canContinue() && loopStart + (long)gcRunPeriod > System.currentTimeMillis()) continue;
            }
            up.estimateTotalBytes$xodus_environment();
            up.setDirty(true);
            GarbageCollector.Companion.loggingInfo$xodus_environment((Function0<String>)((Function0)new Function0<String>(log, up){
                final /* synthetic */ Log $log;
                final /* synthetic */ UtilizationProfile $up;
                {
                    this.$log = $log;
                    this.$up = $up;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Finished background cleaner loop for " + this.$log.getLocation() + ", free space: " + this.$up.totalFreeSpacePercent$xodus_environment() + '%';
                }
            }));
        }
        catch (Throwable throwable) {
            up.estimateTotalBytes$xodus_environment();
            up.setDirty(true);
            GarbageCollector.Companion.loggingInfo$xodus_environment((Function0<String>)((Function0)new /* invalid duplicate definition of identical inner class */));
            throw throwable;
        }
    }

    private final synchronized boolean cleanFiles(GarbageCollector gc, Iterator<Long> fragmentedFiles) {
        return gc.cleanFiles$xodus_environment(fragmentedFiles);
    }

    private final boolean canContinue() {
        GarbageCollector garbageCollector = this.getGc();
        if (garbageCollector == null) {
            return false;
        }
        GarbageCollector gc = garbageCollector;
        BackgroundCleaner cleaner = gc.getCleaner$xodus_environment();
        if (cleaner.isSuspended() || cleaner.isFinished()) {
            return false;
        }
        EnvironmentConfig environmentConfig = gc.getEnvironment$xodus_environment().getEnvironmentConfig();
        Intrinsics.checkNotNullExpressionValue((Object)environmentConfig, (String)"gc.environment.environmentConfig");
        EnvironmentConfig ec = environmentConfig;
        return ec.isGcEnabled() && !ec.getEnvIsReadonly() && gc.isTooMuchFreeSpace$xodus_environment();
    }

    private final void wakeAt(GarbageCollector gc, long time) {
        GarbageCollector.Companion.loggingDebug$xodus_environment((Function0<String>)((Function0)new Function0<String>(gc, time){
            final /* synthetic */ GarbageCollector $gc;
            final /* synthetic */ long $time;
            {
                this.$gc = $gc;
                this.$time = $time;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string = this.$gc.getEnvironment$xodus_environment().getLocation();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gc.environment.location");
                String location = string;
                return "Queueing BackgroundCleaningJob[" + location + "] to wake up at [" + new Date(this.$time) + ']';
            }
        }));
        gc.wakeAt$xodus_environment(time);
    }
}

