/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import java.io.PrintStream;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.tree.Dumpable;
import jetbrains.exodus.tree.ITree;
import jetbrains.exodus.tree.btree.AddressIterator;
import jetbrains.exodus.tree.btree.BTreeBase;
import jetbrains.exodus.tree.btree.BTreeDupMutable;
import jetbrains.exodus.tree.btree.BTreeEmpty;
import jetbrains.exodus.tree.btree.BTreeMutable;
import jetbrains.exodus.tree.btree.BTreeMutatingTraverser;
import jetbrains.exodus.tree.btree.BaseLeafNodeMutable;
import jetbrains.exodus.tree.btree.BasePageMutable;
import jetbrains.exodus.tree.btree.ILeafNode;
import jetbrains.exodus.tree.btree.LeafNodeDup;
import org.jetbrains.annotations.NotNull;

class LeafNodeDupMutable
extends BaseLeafNodeMutable {
    @NotNull
    protected final BTreeDupMutable tree;

    LeafNodeDupMutable(@NotNull BTreeDupMutable tree) {
        this.tree = tree;
    }

    @Override
    public long getAddress() {
        return this.tree.address;
    }

    @Override
    @NotNull
    public BTreeBase getTree() {
        return this.tree;
    }

    @Override
    @NotNull
    public AddressIterator addressIterator() {
        BTreeMutatingTraverser traverser = BTreeMutatingTraverser.create(this.tree);
        return new AddressIterator(null, traverser.currentNode.size > 0, traverser);
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public boolean isDup() {
        return true;
    }

    @Override
    public long getDupCount() {
        return this.tree.size;
    }

    @NotNull
    BasePageMutable getRootPage() {
        return this.tree.getRoot();
    }

    @Override
    public boolean valueExists(@NotNull ByteIterable value) {
        return this.tree.hasKey(value);
    }

    @Override
    public int compareKeyTo(@NotNull ByteIterable iterable) {
        return this.tree.key.compareTo((Object)iterable);
    }

    @Override
    public int compareValueTo(@NotNull ByteIterable iterable) {
        return this.getValue().compareTo((Object)iterable);
    }

    @Override
    @NotNull
    public ByteIterable getKey() {
        return this.tree.key;
    }

    @Override
    @NotNull
    public ByteIterable getValue() {
        return this.tree.getRoot().getMinKey().getKey();
    }

    @Override
    public boolean delete(ByteIterable value) {
        return this.tree.delete(value);
    }

    boolean put(@NotNull ByteIterable value) {
        return this.tree.put(value, ByteIterable.EMPTY);
    }

    LeafNodeDupMutable putRight(@NotNull ByteIterable value) {
        this.tree.putRight(value, (ByteIterable)ArrayByteIterable.EMPTY);
        return this;
    }

    @Override
    public long save(ITree mainTree) {
        if (this.tree.mainTree != mainTree) {
            throw new IllegalArgumentException("Can't save LeafNodeDupMutable against mutable tree different from passed on creation");
        }
        return this.tree.save();
    }

    @Override
    public String toString() {
        return "LND* {key:" + this.getKey().toString() + '}';
    }

    @Override
    public void dump(PrintStream out, int level, Dumpable.ToString renderer) {
        super.dump(out, level, renderer);
        this.tree.getRoot().dump(out, level + 1, renderer);
    }

    static LeafNodeDupMutable convert(@NotNull ILeafNode ln, @NotNull BTreeMutable mainTree) {
        boolean isLeafNodeDup = ln.isDup();
        if (isLeafNodeDup && ln instanceof LeafNodeDupMutable) {
            return (LeafNodeDupMutable)ln;
        }
        BTreeDupMutable dupTree = isLeafNodeDup ? ((LeafNodeDup)ln).getTreeCopyMutable() : new BTreeDupMutable((BTreeBase)new BTreeEmpty(mainTree.getLog(), mainTree.getBalancePolicy(), false, mainTree.getStructureId()), ln.getKey());
        dupTree.mainTree = mainTree;
        return LeafNodeDupMutable.convert(ln, mainTree, dupTree);
    }

    static LeafNodeDupMutable convert(@NotNull ILeafNode ln, @NotNull BTreeMutable mainTree, @NotNull BTreeDupMutable dupTree) {
        LeafNodeDupMutable result = new LeafNodeDupMutable(dupTree);
        if (ln.isDup()) {
            return result;
        }
        mainTree.decrementSize(1L);
        result.put(ln.getValue());
        return result;
    }
}

