/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.checks.DuplicatedFunctionImplementationCheck;
import org.sonarsource.kotlin.checks.KtNamedFunctionsFinder;
import org.sonarsource.kotlin.checks.SyntacticEquivalence;

@Rule(key="S4144")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J \u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/sonarsource/kotlin/checks/DuplicatedFunctionImplementationCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "()V", "check", "", "ctx", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "functionDeclarations", "", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "reportDuplicate", "original", "duplicate", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nDuplicatedFunctionImplementationCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuplicatedFunctionImplementationCheck.kt\norg/sonarsource/kotlin/checks/DuplicatedFunctionImplementationCheck\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n215#2,2:100\n1855#3:102\n1856#3:105\n1313#4,2:103\n1#5:106\n*S KotlinDebug\n*F\n+ 1 DuplicatedFunctionImplementationCheck.kt\norg/sonarsource/kotlin/checks/DuplicatedFunctionImplementationCheck\n*L\n55#1:100,2\n60#1:102\n60#1:105\n67#1:103,2\n*E\n"})
public final class DuplicatedFunctionImplementationCheck
extends AbstractCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String BASE_MESSAGE = "Update this function so that its implementation is not identical to";
    private static final int MINIMUM_STATEMENTS_COUNT = 2;

    @Override
    public void visitKtFile(@NotNull KtFile file2, @NotNull KotlinFileContext ctx) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        KtNamedFunctionsFinder functionsFinder = new KtNamedFunctionsFinder();
        file2.accept(functionsFinder);
        Map<PsiElement, List<KtNamedFunction>> $this$forEach$iv = functionsFinder.getFunctions();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<PsiElement, List<KtNamedFunction>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<PsiElement, List<KtNamedFunction>> element$iv;
            Map.Entry<PsiElement, List<KtNamedFunction>> entry = element$iv = iterator2.next();
            boolean bl = false;
            List<KtNamedFunction> functions2 = entry.getValue();
            this.check(ctx, functions2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void check(KotlinFileContext ctx, List<? extends KtNamedFunction> functionDeclarations) {
        Set reportedDuplicates = new HashSet();
        Iterable $this$forEach$iv = CollectionsKt.getIndices((Collection)functionDeclarations);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            void $this$forEach$iv2;
            int element$iv;
            int i = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            KtNamedFunction original = functionDeclarations.get(i);
            Sequence sequence2 = SequencesKt.filter(SequencesKt.filter(SequencesKt.filter(SequencesKt.drop(CollectionsKt.asSequence((Iterable)functionDeclarations), i + 1), (Function1)new Function1<KtNamedFunction, Boolean>((Set<KtNamedFunction>)reportedDuplicates){
                final /* synthetic */ Set<KtNamedFunction> $reportedDuplicates;
                {
                    this.$reportedDuplicates = $reportedDuplicates;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull KtNamedFunction f) {
                    Intrinsics.checkNotNullParameter(f, "f");
                    return !this.$reportedDuplicates.contains(f);
                }
            }), check.1.2.INSTANCE), (Function1)new Function1<KtNamedFunction, Boolean>(original){
                final /* synthetic */ KtNamedFunction $original;
                {
                    this.$original = $original;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull KtNamedFunction f) {
                    Intrinsics.checkNotNullParameter(f, "f");
                    return org.sonarsource.kotlin.checks.DuplicatedFunctionImplementationCheck$Companion.access$areDuplicatedImplementation(DuplicatedFunctionImplementationCheck.Companion, this.$original, f);
                }
            });
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KtNamedFunction duplicate = (KtNamedFunction)element$iv2;
                boolean bl2 = false;
                this.reportDuplicate(ctx, original, duplicate);
                reportedDuplicates.add(duplicate);
            }
        }
    }

    private final void reportDuplicate(KotlinFileContext ctx, KtNamedFunction original, KtNamedFunction duplicate) {
        Object object;
        TextRange textRange2;
        block6: {
            int line;
            block5: {
                PsiElement psiElement = original.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = original;
                }
                PsiElement psiElement2 = psiElement;
                Intrinsics.checkNotNull(psiElement2);
                textRange2 = KotlinTextRanges.INSTANCE.textRange(ctx, psiElement2);
                line = textRange2.start().line();
                object = original.getName();
                if (object == null) break block5;
                String it = object;
                boolean bl = false;
                String string2 = "Update this function so that its implementation is not identical to \"" + it + "\" on line " + line + ".";
                object = string2;
                if (string2 != null) break block6;
            }
            object = "Update this function so that its implementation is not identical to the one on line " + line + ".";
        }
        Object message2 = object;
        AbstractCheck abstractCheck = this;
        PsiElement psiElement = duplicate.getNameIdentifier();
        if (psiElement == null) {
            psiElement = duplicate;
        }
        PsiElement psiElement3 = psiElement;
        Intrinsics.checkNotNull(psiElement3);
        AbstractCheck.reportIssue$default(abstractCheck, ctx, psiElement3, (String)message2, CollectionsKt.listOf(new SecondaryLocation(textRange2, "original implementation")), null, 8, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/sonarsource/kotlin/checks/DuplicatedFunctionImplementationCheck$Companion;", "", "()V", "BASE_MESSAGE", "", "MINIMUM_STATEMENTS_COUNT", "", "areDuplicatedImplementation", "", "original", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "possibleDuplicate", "hasMinimumSize", "function", "sonar-kotlin-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean hasMinimumSize(KtNamedFunction function2) {
            Object object = function2.getBodyBlockExpression();
            if (object == null || (object = ((KtBlockExpression)object).getStatements()) == null) {
                return false;
            }
            Object statements = object;
            return statements.size() >= 2;
        }

        private final boolean areDuplicatedImplementation(KtNamedFunction original, KtNamedFunction possibleDuplicate) {
            return SyntacticEquivalence.INSTANCE.areEquivalent(original, possibleDuplicate);
        }

        public static final /* synthetic */ boolean access$hasMinimumSize(Companion $this, KtNamedFunction function2) {
            return $this.hasMinimumSize(function2);
        }

        public static final /* synthetic */ boolean access$areDuplicatedImplementation(Companion $this, KtNamedFunction original, KtNamedFunction possibleDuplicate) {
            return $this.areDuplicatedImplementation(original, possibleDuplicate);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

