/*
 * Decompiled with CFR 0.152.
 */
package ru.bozaro.gitlfs.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.bozaro.gitlfs.common.data.Meta;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J \u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lru/bozaro/gitlfs/common/io/InputStreamValidator;", "Ljava/io/InputStream;", "stream", "meta", "Lru/bozaro/gitlfs/common/data/Meta;", "(Ljava/io/InputStream;Lru/bozaro/gitlfs/common/data/Meta;)V", "digest", "Ljava/security/MessageDigest;", "eof", "", "totalSize", "", "checkSize", "", "size", "", "close", "read", "buffer", "", "off", "len", "Companion", "gitlfs-common"})
public final class InputStreamValidator
extends InputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private MessageDigest digest;
    @NotNull
    private final InputStream stream;
    @NotNull
    private final Meta meta;
    private boolean eof;
    private long totalSize;
    @NotNull
    private static final char[] hexDigits;

    public InputStreamValidator(@NotNull InputStream stream, @NotNull Meta meta) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
        try {
            this.digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        this.stream = stream;
        this.meta = meta;
        this.eof = false;
        this.totalSize = 0L;
    }

    @Override
    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        int data = this.stream.read();
        if (data >= 0) {
            MessageDigest messageDigest = this.digest;
            Intrinsics.checkNotNull((Object)messageDigest);
            messageDigest.update((byte)data);
            this.checkSize(1);
        } else {
            this.checkSize(-1);
        }
        return data;
    }

    private final void checkSize(int size) throws IOException {
        if (size > 0) {
            this.totalSize += (long)size;
        }
        long l = this.totalSize;
        long l2 = this.meta.getSize();
        boolean bl = 1L <= l2 ? l2 < l : false;
        if (bl) {
            throw new IOException("Input stream too big");
        }
        if (size < 0) {
            this.eof = true;
            if (this.meta.getSize() >= 0L && this.totalSize != this.meta.getSize()) {
                throw new IOException("Unexpected end of stream");
            }
            MessageDigest messageDigest = this.digest;
            Intrinsics.checkNotNull((Object)messageDigest);
            byte[] byArray = messageDigest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest!!.digest()");
            String hash = InputStreamValidator.Companion.toHexString(byArray);
            if (!Intrinsics.areEqual((Object)this.meta.getOid(), (Object)hash)) {
                throw new IOException("Invalid stream hash");
            }
        }
    }

    @Override
    public int read(@NotNull byte[] buffer, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (this.eof) {
            return -1;
        }
        int size = this.stream.read(buffer, off, len);
        if (size > 0) {
            MessageDigest messageDigest = this.digest;
            Intrinsics.checkNotNull((Object)messageDigest);
            messageDigest.update(buffer, off, size);
        }
        this.checkSize(size);
        return size;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    static {
        char[] cArray = "0123456789abcdef".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        hexDigits = cArray;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lru/bozaro/gitlfs/common/io/InputStreamValidator$Companion;", "", "()V", "hexDigits", "", "toHexString", "", "bytes", "", "gitlfs-common"})
    public static final class Companion {
        private Companion() {
        }

        private final String toHexString(byte[] bytes) {
            StringBuilder sb = new StringBuilder(2 * bytes.length);
            for (byte b : bytes) {
                sb.append(hexDigits[b >> 4 & 0xF]).append(hexDigits[b & 0xF]);
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

