/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.matcher;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.IToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class OrTokenMatcher
implements ITokenMatcher {
    private final List<ITokenMatcher> matchers;

    public OrTokenMatcher(Collection<? extends ITokenMatcher> matchers) {
        Objects.requireNonNull(matchers, "matchers");
        if (matchers.isEmpty()) {
            throw new IllegalArgumentException("matchers must not be empty");
        }
        this.matchers = new ArrayList<ITokenMatcher>(matchers);
    }

    @Override
    public boolean matches(IToken token) {
        return this.matchers.stream().anyMatch(mather -> mather.matches(token));
    }

    @Override
    public ITokenMatcher or(ITokenMatcher ... further) {
        return ITokenMatcher.or(Stream.concat(this.matchers.stream(), Arrays.stream(further)).toList());
    }

    @Override
    public String humanReadable() {
        return this.matchers.stream().map(ITokenMatcher::humanReadable).collect(Collectors.joining(" || ", "(", ")"));
    }
}

