/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ILineAdjuster;
import org.conqat.engine.commons.findings.location.LocationAdjuster;
import org.conqat.engine.sourcecode.coverage.CoverageProbeBase;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.ProbeCoverageInfo;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.collections.CompactLines;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.region.LineBasedRegion;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class TestCoverageUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static LineCoverageInfo adjustCoverageInfo(LineCoverageInfo coverageInfo, ILineAdjuster adjuster, String appendToErrorMessage, boolean reportInvalidLines) {
        if (coverageInfo == null) {
            return null;
        }
        LineCoverageInfo adjustedCoverageInfo = new LineCoverageInfo(coverageInfo.getUploadCommitTimestamp(), coverageInfo.getCodeCommitTimestamp(), coverageInfo.isMethodAccurate());
        for (ELineCoverage lineCoverageType : ELineCoverage.values()) {
            CompactLines relevantLines = lineCoverageType.getRelevantLines(coverageInfo);
            TestCoverageUtils.adjustLines(relevantLines, lineCoverageType, adjustedCoverageInfo, adjuster, appendToErrorMessage, reportInvalidLines);
        }
        return adjustedCoverageInfo;
    }

    public static LineCoverageInfo adjustCoverageInfo(LineCoverageInfo coverageInfo, ILineAdjuster adjuster, String appendToErrorMessage) {
        return TestCoverageUtils.adjustCoverageInfo(coverageInfo, adjuster, appendToErrorMessage, true);
    }

    private static void adjustLines(CompactLines lines, ELineCoverage coverageType, LineCoverageInfo adjustedCoverageInfo, ILineAdjuster adjuster, String appendToErrorMessage, boolean reportInvalidLines) {
        HashSet<Integer> invalidLines = new HashSet<Integer>();
        Iterator iterator = lines.iterator();
        while (iterator.hasNext()) {
            int line = (Integer)iterator.next();
            LineBasedRegion adjustedLines = adjuster.adjustLine(line, invalidLines);
            if (adjustedLines == null) continue;
            for (int adjustedLine = adjustedLines.getStart(); adjustedLine <= adjustedLines.getEnd(); ++adjustedLine) {
                adjustedCoverageInfo.addLineCoverage(adjustedLine, coverageType);
            }
        }
        if (reportInvalidLines) {
            TestCoverageUtils.reportInvalidLines(appendToErrorMessage, invalidLines, adjuster);
        }
    }

    public static void reportInvalidLines(String appendToErrorMessage, Set<Integer> invalidLines, ILineAdjuster adjuster) {
        if (!invalidLines.isEmpty()) {
            LOGGER.warn("Encountered invalid lines: " + String.valueOf(invalidLines) + ". Line count: " + adjuster.getOriginalLineCount() + ". " + appendToErrorMessage);
        }
    }

    public static void adjustProbeBasedCoverage(ProbeCoverageInfo probeCoverageInfo, LocationAdjuster adjuster, String appendToErrorMessage, boolean reportInvalidLines) {
        if (probeCoverageInfo == null) {
            return;
        }
        HashSet<Integer> invalidLines = new HashSet<Integer>();
        UnmodifiableList<CoverageProbeBase> probes = probeCoverageInfo.getProbes();
        ArrayList<CoverageProbeBase> validProbes = new ArrayList<CoverageProbeBase>();
        for (CoverageProbeBase probe : probes) {
            LineBasedRegion adjustedRegion = adjuster.adjustLine(probe.getLine(), invalidLines);
            if (adjustedRegion == null) continue;
            validProbes.add(probe);
            probe.setLine(adjustedRegion.getStart());
        }
        if (reportInvalidLines) {
            TestCoverageUtils.reportInvalidLines(appendToErrorMessage, invalidLines, adjuster);
        }
        probeCoverageInfo.setProbes(validProbes);
    }

    public static void adjustProbeBasedCoverage(ProbeCoverageInfo probeCoverageInfo, LocationAdjuster adjuster, String appendToErrorMessage) {
        TestCoverageUtils.adjustProbeBasedCoverage(probeCoverageInfo, adjuster, appendToErrorMessage, true);
    }

    public static void adjustCoverageToStatements(LineCoverageInfo coverage, TokenElementLineInfo tokenElementLineInfo) {
        coverage.extendCoverageToStatements(tokenElementLineInfo.getMultilineStatementRegions());
    }

    private TestCoverageUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

