/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.dotnet;

import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.dotnet.ECoverageXmlElement;
import org.conqat.engine.sourcecode.coverage.dotnet.LookupBasedCoverageCreator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MSCoverageLineCoverageHandler
extends DefaultHandler {
    private final StringBuilder textContent = new StringBuilder();
    private int lineStart = -1;
    private int lineEnd = -1;
    private int sourceFileID = -1;
    private int coverage = -1;
    private String sourceFileName = null;
    private LookupBasedCoverageCreator coverageCreator;

    public MSCoverageLineCoverageHandler(LookupBasedCoverageCreator coverageCreator) {
        this.coverageCreator = coverageCreator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.textContent.setLength(0);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        ECoverageXmlElement element = (ECoverageXmlElement)ECoverageXmlElement.VALUES.valueOf(localName);
        if (element == null) {
            return;
        }
        switch (element) {
            case LnStart: {
                this.lineStart = this.parseCurrentTextAsInt();
                break;
            }
            case LnEnd: {
                this.lineEnd = this.parseCurrentTextAsInt();
                break;
            }
            case SourceFileID: {
                this.sourceFileID = this.parseCurrentTextAsInt();
                break;
            }
            case Coverage: {
                this.coverage = this.parseCurrentTextAsInt();
                break;
            }
            case Lines: {
                this.endLinesElement();
                break;
            }
            case SourceFileName: {
                this.sourceFileName = this.currentText();
                break;
            }
            case SourceFileNames: {
                this.coverageCreator.storeFileMapping(this.sourceFileID, this.sourceFileName);
                break;
            }
        }
    }

    private void endLinesElement() {
        this.coverageCreator.addLineCoverage(this.sourceFileID, this.lineStart, this.lineEnd, MSCoverageLineCoverageHandler.getLineCoverage(this.coverage));
    }

    private int parseCurrentTextAsInt() throws SAXException {
        try {
            return Integer.parseInt(this.currentText());
        }
        catch (NumberFormatException e) {
            throw new SAXException("Error parsing number: " + e.getMessage());
        }
    }

    private static ELineCoverage getLineCoverage(int coverage) {
        if (coverage == 1) {
            return ELineCoverage.PARTIALLY_COVERED;
        }
        if (coverage == 0) {
            return ELineCoverage.FULLY_COVERED;
        }
        return ELineCoverage.NOT_COVERED;
    }

    private String currentText() {
        return this.textContent.toString().trim();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.textContent.append(ch, start, length);
    }
}

