/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.volume.condition;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.EnumSet;
import java.util.List;
import org.conqat.engine.sourcecode.coverage.volume.condition.Condition;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionExtractorBase;

public class AdaConditionExtractor
extends ConditionExtractorBase {
    public AdaConditionExtractor() {
        super(EnumSet.of(ETokenType.AND, new ETokenType[]{ETokenType.OR, ETokenType.XOR, ETokenType.EQ, ETokenType.NOTEQ, ETokenType.LT, ETokenType.GT, ETokenType.LTEQ, ETokenType.GTEQ, ETokenType.NOT}));
    }

    @Override
    public Condition extractCondition(ShallowEntity entity) {
        switch (entity.getSubtype()) {
            case "if": 
            case "elsif": 
            case "while": {
                return AdaConditionExtractor.stripFirstAndLast((List<IToken>)entity.ownStartTokens(), 1);
            }
            case "exit": {
                return AdaConditionExtractor.stripFirstAndLast((List<IToken>)entity.includedTokens(), 2);
            }
        }
        return null;
    }

    private static Condition stripFirstAndLast(List<IToken> tokens, int numFirst) {
        if (tokens.size() < numFirst + 2) {
            return null;
        }
        return new Condition(tokens.subList(numFirst, tokens.size() - 1));
    }

    @Override
    protected boolean isDoubleOperator(ETokenType type1, ETokenType type2) {
        return type1 == ETokenType.EQ && type2 == ETokenType.GT;
    }
}

