/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.volume.condition;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.conqat.engine.sourcecode.coverage.volume.condition.Condition;
import org.conqat.lib.commons.collections.UnmodifiableList;

public abstract class SubConditionParserBase {
    public abstract List<Condition> getSubConditions(Condition var1);

    public static List<Condition> splitCondition(Condition condition, Set<ETokenType> splitOnType, List<ETokenType> openingTypes, List<ETokenType> closingTypes) {
        return SubConditionParserBase.splitConditionOn(condition, splitOnType, openingTypes, closingTypes, false);
    }

    public static List<Condition> splitConditionOnFirst(Condition condition, Set<ETokenType> splitOnType, List<ETokenType> openingTypes, List<ETokenType> closingTypes) {
        return SubConditionParserBase.splitConditionOn(condition, splitOnType, openingTypes, closingTypes, true);
    }

    private static List<Condition> splitConditionOn(Condition condition, Set<ETokenType> splitOnType, List<ETokenType> openingTypes, List<ETokenType> closingTypes, boolean onFirst) {
        ArrayList<Condition> subConditions = new ArrayList<Condition>();
        if ((condition = condition.cleanupAllParentheses()).isEmptyOrSingleLiteral()) {
            subConditions.add(condition);
            return subConditions;
        }
        UnmodifiableList<IToken> tokens = condition.getTokens();
        List splits = TokenStreamUtils.getTopLevelTokenTypeIndices(tokens, splitOnType, openingTypes, closingTypes);
        if (splits.isEmpty()) {
            subConditions.add(condition);
            return subConditions;
        }
        Condition splitCondition = new Condition(tokens.subList(0, (Integer)splits.get(0))).cleanupAllParentheses();
        subConditions.add(splitCondition);
        if (onFirst) {
            Condition remainder = new Condition(tokens.subList((Integer)splits.get(0) + 1, tokens.size())).cleanupAllParentheses();
            subConditions.add(remainder);
            return subConditions;
        }
        for (int i = 0; i < splits.size() - 1; ++i) {
            splitCondition = new Condition(tokens.subList((Integer)splits.get(i) + 1, (Integer)splits.get(i + 1))).cleanupAllParentheses();
            subConditions.add(splitCondition);
        }
        splitCondition = new Condition(tokens.subList((Integer)splits.get(splits.size() - 1) + 1, tokens.size())).cleanupAllParentheses();
        subConditions.add(splitCondition);
        return subConditions;
    }

    public static List<Condition> splitCondition(Condition condition, ETokenType splitOnType, ETokenType openingTypes, ETokenType closingTypes) {
        return SubConditionParserBase.splitCondition(condition, Set.of(splitOnType), List.of(openingTypes), List.of(closingTypes));
    }
}

