/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core;

import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonarsource.sonarlint.core.ServerApiProvider;
import org.sonarsource.sonarlint.core.clientapi.SonarLintClient;
import org.sonarsource.sonarlint.core.clientapi.client.message.ShowSoonUnsupportedMessageParams;
import org.sonarsource.sonarlint.core.commons.Binding;
import org.sonarsource.sonarlint.core.commons.ConnectionKind;
import org.sonarsource.sonarlint.core.commons.Version;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.event.BindingConfigChangedEvent;
import org.sonarsource.sonarlint.core.event.ConfigurationScopesAddedEvent;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationRepository;
import org.sonarsource.sonarlint.core.repository.connection.AbstractConnectionConfiguration;
import org.sonarsource.sonarlint.core.repository.connection.ConnectionConfigurationRepository;
import org.sonarsource.sonarlint.core.serverapi.ServerApi;
import org.sonarsource.sonarlint.core.serverconnection.VersionUtils;
import org.sonarsource.sonarlint.core.sync.SynchronizationServiceImpl;

@Named
@Singleton
public class VersionSoonUnsupportedHelper {
    private static final String UNSUPPORTED_NOTIFICATION_ID = "sonarlint.unsupported.%s.%s.id";
    private static final String NOTIFICATION_MESSAGE = "The version '%s' used by the current connection '%s' will be soon unsupported. Please consider upgrading to the latest %s LTS version to ensure continued support and access to the latest features.";
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final SonarLintClient client;
    private final ConfigurationRepository configRepository;
    private final ConnectionConfigurationRepository connectionRepository;
    private final ServerApiProvider serverApiProvider;
    private final SynchronizationServiceImpl synchronizationService;
    private final Map<String, Version> cacheConnectionIdPerVersion;

    public VersionSoonUnsupportedHelper(SonarLintClient client, ConfigurationRepository configRepository, ServerApiProvider serverApiProvider, ConnectionConfigurationRepository connectionRepository, SynchronizationServiceImpl synchronizationService) {
        this.client = client;
        this.configRepository = configRepository;
        this.connectionRepository = connectionRepository;
        this.serverApiProvider = serverApiProvider;
        this.synchronizationService = synchronizationService;
        this.cacheConnectionIdPerVersion = new HashMap<String, Version>();
    }

    @Subscribe
    public void configurationScopesAdded(ConfigurationScopesAddedEvent event) {
        Set<String> configScopeIds = event.getAddedConfigurationScopeIds();
        this.checkIfSoonUnsupported(configScopeIds);
    }

    @Subscribe
    public void bindingConfigChanged(BindingConfigChangedEvent event) {
        String configScopeId = event.getConfigScopeId();
        String connectionId = event.getNewConfig().getConnectionId();
        if (connectionId != null) {
            this.checkIfSoonUnsupported(configScopeId, connectionId);
        }
    }

    private void checkIfSoonUnsupported(Set<String> configScopeIds) {
        HashMap<String, String> connectionsPerConfigScopeId = new HashMap<String, String>();
        configScopeIds.forEach(configScopeId -> {
            Optional<Binding> effectiveBinding = this.configRepository.getEffectiveBinding((String)configScopeId);
            if (effectiveBinding.isPresent()) {
                String connectionId = effectiveBinding.get().getConnectionId();
                connectionsPerConfigScopeId.putIfAbsent(connectionId, (String)configScopeId);
            }
        });
        connectionsPerConfigScopeId.forEach((key, value) -> this.checkIfSoonUnsupported((String)value, (String)key));
    }

    private void checkIfSoonUnsupported(String configScopeId, String connectionId) {
        Optional<ServerApi> serverInfo;
        AbstractConnectionConfiguration connection = this.connectionRepository.getConnectionById(connectionId);
        if (connection != null && connection.getKind() == ConnectionKind.SONARQUBE && (serverInfo = this.serverApiProvider.getServerApi(connectionId)).isPresent()) {
            boolean isCached;
            Version version = this.synchronizationService.getServerConnection(connectionId, serverInfo.get()).readOrSynchronizeServerVersion(serverInfo.get());
            boolean bl = isCached = this.cacheConnectionIdPerVersion.containsKey(connectionId) && this.cacheConnectionIdPerVersion.get(connectionId).compareTo(version) == 0;
            if (!isCached && VersionUtils.isVersionSupportedDuringGracePeriod(version)) {
                this.client.showSoonUnsupportedMessage(new ShowSoonUnsupportedMessageParams(String.format(UNSUPPORTED_NOTIFICATION_ID, connectionId, version.getName()), configScopeId, String.format(NOTIFICATION_MESSAGE, version.getName(), connectionId, VersionUtils.getCurrentLts())));
                LOG.debug(String.format("Connection ID '%s' with version '%s' is detected to be soon unsupported", connection.getConnectionId(), version.getName()));
            }
            this.cacheConnectionIdPerVersion.put(connectionId, version);
        }
    }
}

