/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.analysis.filesystem;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonarsource.api.sonarlint.SonarLintSide;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.shaded.org.apache.commons.io.ByteOrderMark;
import org.sonarsource.sonarlint.shaded.org.apache.commons.io.input.BOMInputStream;

@SonarLintSide
public class FileMetadata {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private static final char LINE_FEED = '\n';
    private static final char CARRIAGE_RETURN = '\r';

    Metadata readMetadata(File file, Charset encoding) {
        InputStream stream = FileMetadata.streamFile(file);
        return this.readMetadata(stream, encoding, file.toURI(), null);
    }

    public Metadata readMetadata(InputStream stream, Charset encoding, URI fileUri, @Nullable CharHandler otherHandler) {
        LineCounter lineCounter = new LineCounter(fileUri, encoding);
        LineOffsetCounter lineOffsetCounter = new LineOffsetCounter();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, encoding));){
            CharHandler[] handlers = otherHandler != null ? new CharHandler[]{lineCounter, lineOffsetCounter, otherHandler} : new CharHandler[]{lineCounter, lineOffsetCounter};
            FileMetadata.read(reader, handlers);
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Fail to read file '%s' with encoding '%s'", fileUri, encoding), e);
        }
        return new Metadata(lineCounter.lines(), lineOffsetCounter.getOriginalLineOffsets().stream().mapToInt(i -> i).toArray(), lineOffsetCounter.getLastValidOffset());
    }

    private static InputStream streamFile(File file) {
        try {
            return new BOMInputStream((InputStream)new FileInputStream(file), ByteOrderMark.UTF_8, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_32LE, ByteOrderMark.UTF_32BE);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("File not found: " + file.getAbsolutePath(), e);
        }
    }

    private static void read(Reader reader, CharHandler ... handlers) throws IOException {
        int i = reader.read();
        boolean afterCR = false;
        while (i != -1) {
            char c = (char)i;
            if (afterCR) {
                for (CharHandler handler : handlers) {
                    if (c == '\r') {
                        handler.newLine();
                        handler.handleAll(c);
                        continue;
                    }
                    if (c == '\n') {
                        handler.handleAll(c);
                        handler.newLine();
                        continue;
                    }
                    handler.newLine();
                    handler.handleIgnoreEoL(c);
                    handler.handleAll(c);
                }
                afterCR = c == '\r';
            } else if (c == '\n') {
                for (CharHandler handler : handlers) {
                    handler.handleAll(c);
                    handler.newLine();
                }
            } else if (c == '\r') {
                afterCR = true;
                for (CharHandler handler : handlers) {
                    handler.handleAll(c);
                }
            } else {
                for (CharHandler handler : handlers) {
                    handler.handleIgnoreEoL(c);
                    handler.handleAll(c);
                }
            }
            i = reader.read();
        }
        for (CharHandler handler : handlers) {
            if (afterCR) {
                handler.newLine();
            }
            handler.eof();
        }
    }

    public static class Metadata {
        private final int lines;
        private final int[] originalLineOffsets;
        private final int lastValidOffset;

        public Metadata(int lines, int[] originalLineOffsets, int lastValidOffset) {
            this.lines = lines;
            this.originalLineOffsets = originalLineOffsets;
            this.lastValidOffset = lastValidOffset;
        }

        public int lines() {
            return this.lines;
        }

        public int[] originalLineOffsets() {
            return this.originalLineOffsets;
        }

        public int lastValidOffset() {
            return this.lastValidOffset;
        }
    }

    private static class LineOffsetCounter
    extends CharHandler {
        private int currentOriginalOffset = 0;
        private final List<Integer> originalLineOffsets = new ArrayList<Integer>();
        private int lastValidOffset = 0;

        public LineOffsetCounter() {
            this.originalLineOffsets.add(0);
        }

        @Override
        protected void handleAll(char c) {
            ++this.currentOriginalOffset;
        }

        @Override
        protected void newLine() {
            this.originalLineOffsets.add(this.currentOriginalOffset);
        }

        @Override
        protected void eof() {
            this.lastValidOffset = this.currentOriginalOffset;
        }

        public List<Integer> getOriginalLineOffsets() {
            return this.originalLineOffsets;
        }

        public int getLastValidOffset() {
            return this.lastValidOffset;
        }
    }

    private static class LineCounter
    extends CharHandler {
        private int lines = 1;
        boolean alreadyLoggedInvalidCharacter = false;
        private final URI fileUri;
        private final Charset encoding;

        LineCounter(URI fileUri, Charset encoding) {
            this.fileUri = fileUri;
            this.encoding = encoding;
        }

        @Override
        protected void handleAll(char c) {
            if (!this.alreadyLoggedInvalidCharacter && c == '\ufffd') {
                LOG.warn("Invalid character encountered in file '{}' at line {} for encoding {}. Please fix file content or configure the encoding.", this.fileUri, this.lines, this.encoding);
                this.alreadyLoggedInvalidCharacter = true;
            }
        }

        @Override
        protected void newLine() {
            ++this.lines;
        }

        public int lines() {
            return this.lines;
        }
    }

    public static abstract class CharHandler {
        protected void handleAll(char c) {
        }

        protected void handleIgnoreEoL(char c) {
        }

        protected void newLine() {
        }

        protected void eof() {
        }
    }
}

