/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.commons.progress;

import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.progress.CanceledException;
import org.sonarsource.sonarlint.core.commons.progress.ClientProgressMonitor;

public class ProgressMonitor {
    private final ClientProgressMonitor clientMonitor;
    private final float offset;
    private final float factor;
    private final String msgPrefix;
    private volatile boolean canceled;

    private ProgressMonitor(float offset, float factor, @Nullable String msgPrefix, @Nullable ClientProgressMonitor clientMonitor) {
        this.offset = offset;
        this.factor = factor;
        this.msgPrefix = msgPrefix;
        this.clientMonitor = clientMonitor == null ? new NoOpProgressMonitor() : clientMonitor;
    }

    public ProgressMonitor(@Nullable ClientProgressMonitor clientMonitor) {
        this(0.0f, 1.0f, null, clientMonitor);
    }

    public ProgressMonitor subProgress(float fromFraction, float toFraction, String msgPrefix) {
        return new ProgressMonitor(this.offset + fromFraction * this.factor, (toFraction - fromFraction) * this.factor, this.prependPrefix(msgPrefix), this.clientMonitor);
    }

    public void checkCancel() {
        if (this.isCanceled()) {
            this.clientMonitor.setMessage("Cancelling");
            throw new CanceledException();
        }
    }

    public boolean isCanceled() {
        return this.canceled || this.clientMonitor.isCanceled();
    }

    public void cancel() {
        this.canceled = true;
    }

    public void setProgress(String msg, float fraction) {
        this.clientMonitor.setMessage(this.prependPrefix(msg));
        this.setFraction(fraction);
    }

    private String prependPrefix(String suffix) {
        return this.msgPrefix != null ? this.msgPrefix + " - " + suffix : suffix;
    }

    public void setProgressAndCheckCancel(String msg, float fraction) {
        this.checkCancel();
        this.setProgress(msg, fraction);
    }

    private void setFraction(float fraction) {
        this.clientMonitor.setFraction(this.offset + fraction * this.factor);
    }

    public void executeNonCancelableSection(Runnable r) {
        this.clientMonitor.executeNonCancelableSection(r);
    }

    private static class NoOpProgressMonitor
    implements ClientProgressMonitor {
        private NoOpProgressMonitor() {
        }

        @Override
        public void setMessage(String msg) {
        }

        @Override
        public void setFraction(float fraction) {
        }

        @Override
        public void setIndeterminate(boolean indeterminate) {
        }
    }
}

