/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.http;

import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.protocol.HttpContext;

class RedirectInterceptor
implements HttpResponseInterceptor {
    RedirectInterceptor() {
    }

    public void process(HttpResponse response, EntityDetails entity, HttpContext context) {
        RedirectInterceptor.alterResponseCodeIfNeeded(context, response);
    }

    private static void alterResponseCodeIfNeeded(HttpContext context, HttpResponse response) {
        if (RedirectInterceptor.isPost(context)) {
            int code = response.getCode();
            if (code == 301) {
                response.setCode(308);
            } else if (code == 302 || code == 303) {
                response.setCode(307);
            }
        }
    }

    private static boolean isPost(HttpContext context) {
        HttpRequest request = (HttpRequest)context.getAttribute("http.request");
        return request != null && Method.POST.isSame(request.getMethod());
    }
}

