/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin.commons.container;

import org.sonar.api.Startable;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.shaded.org.springframework.beans.BeansException;
import org.sonarsource.sonarlint.shaded.org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.sonarsource.sonarlint.shaded.org.springframework.lang.Nullable;

public class StartableBeanPostProcessor
implements DestructionAwareBeanPostProcessor {
    @Override
    @Nullable
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Startable) {
            ((Startable)bean).start();
        }
        return bean;
    }

    @Override
    public boolean requiresDestruction(Object bean) {
        return bean instanceof Startable;
    }

    @Override
    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        try {
            if (bean instanceof Startable) {
                ((Startable)bean).stop();
            }
        }
        catch (Exception e) {
            SonarLintLogger.get().warn("Dispose of component {} failed", (Object)bean.getClass().getCanonicalName(), (Object)e);
        }
    }
}

