/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin.commons.loading;

import java.io.File;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.utils.MessageException;
import org.sonarsource.sonarlint.core.commons.Version;
import org.sonarsource.sonarlint.core.plugin.commons.loading.SonarPluginManifest;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;

public class PluginInfo {
    private final String key;
    private String name;
    private File jarFile;
    @CheckForNull
    private String mainClass;
    @CheckForNull
    private Version version;
    @CheckForNull
    private Version minimalSqVersion;
    @CheckForNull
    private String basePlugin;
    private final Set<SonarPluginManifest.RequiredPlugin> requiredPlugins = new HashSet<SonarPluginManifest.RequiredPlugin>();
    @CheckForNull
    private Version jreMinVersion;
    @CheckForNull
    private Version nodeJsMinVersion;
    private List<String> dependencies = List.of();

    public PluginInfo(String key) {
        Objects.requireNonNull(key, "Plugin key is missing from manifest");
        this.key = key;
        this.name = key;
    }

    public PluginInfo setJarFile(File f) {
        this.jarFile = f;
        return this;
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    @CheckForNull
    public Version getVersion() {
        return this.version;
    }

    @CheckForNull
    public Version getMinimalSqVersion() {
        return this.minimalSqVersion;
    }

    @CheckForNull
    public String getMainClass() {
        return this.mainClass;
    }

    @CheckForNull
    public String getBasePlugin() {
        return this.basePlugin;
    }

    public Set<SonarPluginManifest.RequiredPlugin> getRequiredPlugins() {
        return this.requiredPlugins;
    }

    @CheckForNull
    public Version getJreMinVersion() {
        return this.jreMinVersion;
    }

    @CheckForNull
    public Version getNodeJsMinVersion() {
        return this.nodeJsMinVersion;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public PluginInfo setName(@Nullable String name) {
        this.name = Optional.ofNullable(name).orElse(this.key);
        return this;
    }

    public PluginInfo setVersion(Version version) {
        this.version = version;
        return this;
    }

    public PluginInfo setMinimalSqVersion(@Nullable Version v) {
        this.minimalSqVersion = v;
        return this;
    }

    public PluginInfo setMainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public PluginInfo setBasePlugin(@Nullable String s) {
        this.basePlugin = s;
        return this;
    }

    public PluginInfo addRequiredPlugin(SonarPluginManifest.RequiredPlugin p) {
        this.requiredPlugins.add(p);
        return this;
    }

    private PluginInfo setMinimalJreVersion(@Nullable Version jreMinVersion) {
        this.jreMinVersion = jreMinVersion;
        return this;
    }

    private PluginInfo setMinimalNodeJsVersion(@Nullable Version nodeJsMinVersion) {
        this.nodeJsMinVersion = nodeJsMinVersion;
        return this;
    }

    public PluginInfo setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public boolean isCompatibleWith(String implementedApi) {
        if (null == this.minimalSqVersion) {
            return true;
        }
        Version requestedApi = Version.create(this.minimalSqVersion.getMajor() + "." + this.minimalSqVersion.getMinor());
        Version implementedApiVersion = Version.create(implementedApi);
        return implementedApiVersion.compareToIgnoreQualifier(requestedApi) >= 0;
    }

    public String toString() {
        return "[" + this.key + " / " + this.version + "]";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginInfo info = (PluginInfo)o;
        if (!this.key.equals(info.key)) {
            return false;
        }
        return !(this.version == null ? info.version != null : !this.version.equals(info.version));
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public static PluginInfo create(Path jarFile) {
        SonarPluginManifest manifest = SonarPluginManifest.fromJar(jarFile);
        return PluginInfo.create(jarFile, manifest);
    }

    static PluginInfo create(Path jarPath, SonarPluginManifest manifest) {
        if (StringUtils.isBlank(manifest.getKey())) {
            throw MessageException.of(String.format("File is not a plugin. Please delete it and restart: %s", jarPath.toAbsolutePath()));
        }
        PluginInfo info = new PluginInfo(manifest.getKey());
        info.setJarFile(jarPath.toFile());
        info.setName(manifest.getName());
        info.setMainClass(manifest.getMainClass());
        info.setVersion(Version.create(manifest.getVersion()));
        info.setMinimalSqVersion(manifest.getSonarMinVersion().orElse(null));
        info.setBasePlugin(manifest.getBasePluginKey());
        manifest.getRequiredPlugins().forEach(info::addRequiredPlugin);
        info.setMinimalJreVersion(manifest.getJreMinVersion().orElse(null));
        info.setMinimalNodeJsVersion(manifest.getNodeJsMinVersion().orElse(null));
        info.setDependencies(manifest.getDependencies());
        return info;
    }
}

