/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.sonarsource.sonarlint.core.clientapi.backend.rules.EffectiveRuleDetailsDto;
import org.sonarsource.sonarlint.core.clientapi.backend.rules.EffectiveRuleParamDto;
import org.sonarsource.sonarlint.core.clientapi.backend.rules.RuleContextualSectionDto;
import org.sonarsource.sonarlint.core.clientapi.backend.rules.RuleContextualSectionWithDefaultContextKeyDto;
import org.sonarsource.sonarlint.core.clientapi.backend.rules.RuleDescriptionTabDto;
import org.sonarsource.sonarlint.core.clientapi.backend.rules.RuleMonolithicDescriptionDto;
import org.sonarsource.sonarlint.core.clientapi.backend.rules.RuleNonContextualSectionDto;
import org.sonarsource.sonarlint.core.clientapi.backend.rules.RuleSplitDescriptionDto;
import org.sonarsource.sonarlint.core.commons.RuleType;
import org.sonarsource.sonarlint.core.rules.CleanCodePrinciples;
import org.sonarsource.sonarlint.core.rules.OthersSectionHtmlContent;
import org.sonarsource.sonarlint.core.rules.RuleDetails;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;

class RuleDetailsAdapter {
    public static final String INTRODUCTION_SECTION_KEY = "introduction";
    public static final String ROOT_CAUSE_SECTION_KEY = "root_cause";
    public static final String ASSESS_THE_PROBLEM_SECTION_KEY = "assess_the_problem";
    public static final String HOW_TO_FIX_SECTION_KEY = "how_to_fix";
    public static final String RESOURCES_SECTION_KEY = "resources";
    private static final String DEFAULT_CONTEXT_KEY = "others";
    private static final String DEFAULT_CONTEXT_DISPLAY_NAME = "Others";
    private static final List<String> SECTION_KEYS_ORDERED = List.of("root_cause", "assess_the_problem", "how_to_fix", "resources");

    public static EffectiveRuleDetailsDto transform(RuleDetails ruleDetails, @javax.annotation.Nullable String contextKey) {
        return new EffectiveRuleDetailsDto(ruleDetails.getKey(), ruleDetails.getName(), ruleDetails.getDefaultSeverity(), ruleDetails.getType(), ruleDetails.getCleanCodeAttribute().orElse(null), ruleDetails.getDefaultImpacts(), RuleDetailsAdapter.transformDescriptions(ruleDetails, contextKey), RuleDetailsAdapter.transform(ruleDetails.getParams()), ruleDetails.getLanguage());
    }

    static Either<RuleMonolithicDescriptionDto, RuleSplitDescriptionDto> transformDescriptions(RuleDetails ruleDetails, @javax.annotation.Nullable String contextKey) {
        if (ruleDetails.hasMonolithicDescription()) {
            return Either.forLeft(RuleDetailsAdapter.transformMonolithicDescription(ruleDetails));
        }
        return Either.forRight(RuleDetailsAdapter.transformSplitDescription(ruleDetails, contextKey));
    }

    private static RuleMonolithicDescriptionDto transformMonolithicDescription(RuleDetails ruleDetails) {
        ArrayList<String> htmlSnippets = new ArrayList<String>();
        htmlSnippets.add(ruleDetails.getHtmlDescription());
        htmlSnippets.add(ruleDetails.getExtendedDescription());
        htmlSnippets.add(RuleDetailsAdapter.getCleanCodePrinciplesContent(ruleDetails.getCleanCodePrincipleKeys()));
        return new RuleMonolithicDescriptionDto(RuleDetailsAdapter.concat(htmlSnippets));
    }

    private static String getCleanCodePrinciplesContent(Set<String> cleanCodePrincipleKeys) {
        List<String> principles = cleanCodePrincipleKeys.stream().sorted(Comparator.naturalOrder()).map(CleanCodePrinciples::getContent).collect(Collectors.toList());
        return (principles.stream().anyMatch(StringUtils::isNotBlank) ? "<h3>Clean Code Principles</h3>\n" : "") + RuleDetailsAdapter.concat(principles);
    }

    private static RuleSplitDescriptionDto transformSplitDescription(RuleDetails ruleDetails, @javax.annotation.Nullable String contextKey) {
        Map<String, List<RuleDetails.DescriptionSection>> sectionsByKey = ruleDetails.getDescriptionSectionsByKey();
        ArrayList<RuleDescriptionTabDto> tabbedSections = new ArrayList<RuleDescriptionTabDto>(RuleDetailsAdapter.transformSectionsButIntroductionToTabs(ruleDetails, contextKey));
        RuleDetailsAdapter.addMoreInfoTabIfNeeded(ruleDetails, tabbedSections);
        return new RuleSplitDescriptionDto(RuleDetailsAdapter.extractIntroductionFromSections(sectionsByKey), tabbedSections);
    }

    @Nullable
    private static String extractIntroductionFromSections(Map<String, List<RuleDetails.DescriptionSection>> sectionsByKey) {
        List<RuleDetails.DescriptionSection> introductionSections = sectionsByKey.get(INTRODUCTION_SECTION_KEY);
        String introductionHtmlContent = null;
        if (introductionSections != null && !introductionSections.isEmpty()) {
            introductionHtmlContent = introductionSections.get(0).getHtmlContent();
        }
        return introductionHtmlContent;
    }

    private static void addMoreInfoTabIfNeeded(RuleDetails ruleDetails, ArrayList<RuleDescriptionTabDto> tabbedSections) {
        if (!ruleDetails.getDescriptionSectionsByKey().containsKey(RESOURCES_SECTION_KEY)) {
            ArrayList<String> htmlSnippets = new ArrayList<String>();
            htmlSnippets.add(ruleDetails.getExtendedDescription());
            htmlSnippets.add(RuleDetailsAdapter.getCleanCodePrinciplesContent(ruleDetails.getCleanCodePrincipleKeys()));
            String content = RuleDetailsAdapter.concat(htmlSnippets);
            if (StringUtils.isNotBlank(content)) {
                tabbedSections.add(new RuleDescriptionTabDto(RuleDetailsAdapter.getTabTitle(ruleDetails, RESOURCES_SECTION_KEY), Either.forLeft(new RuleNonContextualSectionDto(content))));
            }
        }
    }

    private static Collection<RuleDescriptionTabDto> transformSectionsButIntroductionToTabs(RuleDetails ruleDetails, @javax.annotation.Nullable String contextKey) {
        ArrayList<RuleDescriptionTabDto> tabbedSections = new ArrayList<RuleDescriptionTabDto>();
        Map<String, List<RuleDetails.DescriptionSection>> sectionsByKey = ruleDetails.getDescriptionSectionsByKey();
        SECTION_KEYS_ORDERED.forEach(sectionKey -> {
            if (sectionsByKey.containsKey(sectionKey)) {
                Either<RuleNonContextualSectionDto, RuleContextualSectionWithDefaultContextKeyDto> content;
                List tabContents = (List)sectionsByKey.get(sectionKey);
                boolean foundMatchingContext = tabContents.stream().anyMatch(c -> c.getContext().isPresent() && c.getContext().get().getKey().equals(contextKey));
                if (tabContents.size() == 1 && ((RuleDetails.DescriptionSection)tabContents.get(0)).getContext().isEmpty()) {
                    content = RuleDetailsAdapter.buildNonContextualSectionDto(ruleDetails, (RuleDetails.DescriptionSection)tabContents.get(0));
                } else {
                    List<RuleContextualSectionDto> contextualSectionContents = tabContents.stream().map(s -> {
                        RuleDetails.DescriptionSection.Context context = s.getContext().get();
                        return new RuleContextualSectionDto(RuleDetailsAdapter.getTabContent(s, ruleDetails.getExtendedDescription(), ruleDetails.getCleanCodePrincipleKeys()), context.getKey(), context.getDisplayName());
                    }).sorted(Comparator.comparing(RuleContextualSectionDto::getDisplayName)).collect(Collectors.toList());
                    contextualSectionContents.add(new RuleContextualSectionDto(OthersSectionHtmlContent.getHtmlContent(), DEFAULT_CONTEXT_KEY, DEFAULT_CONTEXT_DISPLAY_NAME));
                    content = Either.forRight(new RuleContextualSectionWithDefaultContextKeyDto(foundMatchingContext ? contextKey : DEFAULT_CONTEXT_KEY, contextualSectionContents));
                }
                tabbedSections.add(new RuleDescriptionTabDto(RuleDetailsAdapter.getTabTitle(ruleDetails, sectionKey), content));
            }
        });
        return tabbedSections;
    }

    private static String getTabTitle(RuleDetails ruleDetails, String sectionKey) {
        if (ROOT_CAUSE_SECTION_KEY.equals(sectionKey)) {
            return RuleType.SECURITY_HOTSPOT.equals((Object)ruleDetails.getType()) ? "What's the risk?" : "Why is this an issue?";
        }
        if (ASSESS_THE_PROBLEM_SECTION_KEY.equals(sectionKey)) {
            return "Assess the risk";
        }
        if (HOW_TO_FIX_SECTION_KEY.equals(sectionKey)) {
            return "How can I fix it?";
        }
        return "More Info";
    }

    private static String concat(Collection<String> htmlSnippets) {
        return htmlSnippets.stream().filter(StringUtils::isNotBlank).collect(Collectors.joining());
    }

    private static String getTabContent(RuleDetails.DescriptionSection section, @javax.annotation.Nullable String extendedDescription, Set<String> educationPrincipleKeys) {
        ArrayList<String> htmlSnippets = new ArrayList<String>();
        htmlSnippets.add(section.getHtmlContent());
        if (RESOURCES_SECTION_KEY.equals(section.getKey())) {
            htmlSnippets.add(extendedDescription);
            htmlSnippets.add(RuleDetailsAdapter.getCleanCodePrinciplesContent(educationPrincipleKeys));
        }
        return RuleDetailsAdapter.concat(htmlSnippets);
    }

    private static Collection<EffectiveRuleParamDto> transform(Collection<RuleDetails.EffectiveRuleParam> params) {
        ArrayList<EffectiveRuleParamDto> builder = new ArrayList<EffectiveRuleParamDto>();
        for (RuleDetails.EffectiveRuleParam param : params) {
            builder.add(new EffectiveRuleParamDto(param.getName(), param.getDescription(), param.getValue(), param.getDefaultValue()));
        }
        return builder;
    }

    private RuleDetailsAdapter() {
    }

    @NotNull
    private static Either<RuleNonContextualSectionDto, RuleContextualSectionWithDefaultContextKeyDto> buildNonContextualSectionDto(RuleDetails ruleDetails, RuleDetails.DescriptionSection matchingContext) {
        return Either.forLeft(new RuleNonContextualSectionDto(RuleDetailsAdapter.getTabContent(matchingContext, ruleDetails.getExtendedDescription(), ruleDetails.getCleanCodePrincipleKeys())));
    }
}

