/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.rules;

import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonarsource.sonarlint.core.clientapi.backend.initialize.InitializeParams;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.languages.LanguageSupportRepository;
import org.sonarsource.sonarlint.core.plugin.PluginsServiceImpl;
import org.sonarsource.sonarlint.core.rule.extractor.RulesDefinitionExtractor;
import org.sonarsource.sonarlint.core.rule.extractor.SonarLintRuleDefinition;

@Named
@Singleton
public class RulesExtractionHelper {
    private final SonarLintLogger logger = SonarLintLogger.get();
    private final PluginsServiceImpl pluginsService;
    private final LanguageSupportRepository languageSupportRepository;
    private final RulesDefinitionExtractor ruleExtractor = new RulesDefinitionExtractor();
    private final boolean enableSecurityHotspots;

    public RulesExtractionHelper(PluginsServiceImpl pluginsService, LanguageSupportRepository languageSupportRepository, InitializeParams params) {
        this.pluginsService = pluginsService;
        this.languageSupportRepository = languageSupportRepository;
        this.enableSecurityHotspots = params.getFeatureFlags().isEnableSecurityHotspots();
    }

    public List<SonarLintRuleDefinition> extractEmbeddedRules() {
        this.logger.debug("Extracting standalone rules metadata");
        return this.ruleExtractor.extractRules(this.pluginsService.getEmbeddedPlugins().getPluginInstancesByKeys(), this.languageSupportRepository.getEnabledLanguagesInStandaloneMode(), false, false);
    }

    public List<SonarLintRuleDefinition> extractRulesForConnection(String connectionId) {
        this.logger.debug("Extracting rules metadata for connection '{}'", (Object)connectionId);
        return this.ruleExtractor.extractRules(this.pluginsService.getPlugins(connectionId).getPluginInstancesByKeys(), this.languageSupportRepository.getEnabledLanguagesInConnectedMode(), true, this.enableSecurityHotspots);
    }
}

