/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.push.parsing;

import java.time.Instant;
import java.util.Optional;
import org.sonarsource.sonarlint.core.commons.HotspotReviewStatus;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.serverapi.push.SecurityHotspotChangedEvent;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.EventParser;
import org.sonarsource.sonarlint.core.serverapi.util.ServerApiUtils;
import org.sonarsource.sonarlint.shaded.com.google.gson.Gson;

public class SecurityHotspotChangedEventParser
implements EventParser<SecurityHotspotChangedEvent> {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final Gson gson = new Gson();

    @Override
    public Optional<SecurityHotspotChangedEvent> parse(String jsonData) {
        HotspotChangedEventPayload payload = this.gson.fromJson(jsonData, HotspotChangedEventPayload.class);
        if (payload.isInvalid()) {
            LOG.error("Invalid payload for 'SecurityHotspotChanged' event: {}", (Object)jsonData);
            return Optional.empty();
        }
        return Optional.of(new SecurityHotspotChangedEvent(payload.key, payload.projectKey, Instant.ofEpochMilli(payload.updateDate), HotspotReviewStatus.fromStatusAndResolution(payload.status, payload.resolution), payload.assignee, payload.filePath));
    }

    private static class HotspotChangedEventPayload {
        private String key;
        private String projectKey;
        private String status;
        private String resolution;
        private long updateDate;
        private String assignee;
        private String filePath;

        private HotspotChangedEventPayload() {
        }

        public String getKey() {
            return this.key;
        }

        public String getProjectKey() {
            return this.projectKey;
        }

        public String getStatus() {
            return this.status;
        }

        public String getResolution() {
            return this.resolution;
        }

        public long getUpdateDate() {
            return this.updateDate;
        }

        public String getAssignee() {
            return this.assignee;
        }

        private boolean isInvalid() {
            return ServerApiUtils.isBlank(this.key) || ServerApiUtils.isBlank(this.projectKey) || this.updateDate == 0L || ServerApiUtils.isBlank(this.filePath);
        }
    }
}

