/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.qualityprofile;

import java.util.List;
import java.util.stream.Collectors;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.serverapi.ServerApiHelper;
import org.sonarsource.sonarlint.core.serverapi.UrlUtils;
import org.sonarsource.sonarlint.core.serverapi.exception.NotFoundException;
import org.sonarsource.sonarlint.core.serverapi.exception.ProjectNotFoundException;
import org.sonarsource.sonarlint.core.serverapi.proto.sonarqube.ws.Qualityprofiles;
import org.sonarsource.sonarlint.core.serverapi.qualityprofile.QualityProfile;

public class QualityProfileApi {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private static final String DEFAULT_QP_SEARCH_URL = "/api/qualityprofiles/search.protobuf";
    private final ServerApiHelper helper;

    public QualityProfileApi(ServerApiHelper helper) {
        this.helper = helper;
    }

    public List<QualityProfile> getQualityProfiles(String projectKey) {
        StringBuilder url = new StringBuilder();
        url.append("/api/qualityprofiles/search.protobuf?project=");
        url.append(UrlUtils.urlEncode(projectKey));
        this.helper.getOrganizationKey().ifPresent(org -> url.append("&organization=").append(UrlUtils.urlEncode(org)));
        try {
            Qualityprofiles.SearchWsResponse qpResponse = ServerApiHelper.processTimed(() -> this.helper.get(url.toString()), response -> Qualityprofiles.SearchWsResponse.parseFrom(response.bodyAsStream()), duration -> LOG.debug("Downloaded project quality profiles in {}ms", (Object)duration));
            return qpResponse.getProfilesList().stream().map(QualityProfileApi::adapt).collect(Collectors.toList());
        }
        catch (NotFoundException e) {
            throw new ProjectNotFoundException(projectKey, this.helper.getOrganizationKey().orElse(null));
        }
    }

    private static QualityProfile adapt(Qualityprofiles.SearchWsResponse.QualityProfile wsQualityProfile) {
        return new QualityProfile(wsQualityProfile.getIsDefault(), wsQualityProfile.getKey(), wsQualityProfile.getName(), wsQualityProfile.getLanguage(), wsQualityProfile.getLanguageName(), wsQualityProfile.getActiveRuleCount(), wsQualityProfile.getRulesUpdatedAt(), wsQualityProfile.getUserUpdatedAt());
    }
}

