/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.source;

import java.util.Optional;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.http.HttpClient;
import org.sonarsource.sonarlint.core.serverapi.ServerApiHelper;
import org.sonarsource.sonarlint.core.serverapi.UrlUtils;

public class SourceApi {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final ServerApiHelper serverApiHelper;

    public SourceApi(ServerApiHelper serverApiHelper) {
        this.serverApiHelper = serverApiHelper;
    }

    public Optional<String> getRawSourceCode(String fileKey) {
        HttpClient.Response r = this.serverApiHelper.get("/api/sources/raw?key=" + UrlUtils.urlEncode(fileKey));
        try {
            Optional<String> optional = Optional.of(r.bodyAsString());
            if (r != null) {
                r.close();
            }
            return optional;
        }
        catch (Throwable throwable) {
            try {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.debug("Unable to fetch source code of '" + fileKey + "'", (Object)e);
                return Optional.empty();
            }
        }
    }

    public Optional<String> getRawSourceCodeForBranchAndPullRequest(String fileKey, String branch, @Nullable String pullRequest) {
        Object url = "/api/sources/raw?key=" + UrlUtils.urlEncode(fileKey);
        if (pullRequest != null && !pullRequest.isEmpty()) {
            url = ((String)url).concat("&pullRequest=").concat(UrlUtils.urlEncode(pullRequest));
        } else if (!branch.isEmpty()) {
            url = ((String)url).concat("&branch=").concat(UrlUtils.urlEncode(branch));
        }
        HttpClient.Response r = this.serverApiHelper.get((String)url);
        try {
            Optional<String> optional = Optional.of(r.bodyAsString());
            if (r != null) {
                r.close();
            }
            return optional;
        }
        catch (Throwable throwable) {
            try {
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.debug("Unable to fetch source code of '" + fileKey + "'", (Object)e);
                return Optional.empty();
            }
        }
    }
}

