/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.system;

import java.util.concurrent.CompletableFuture;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.serverapi.ServerApiHelper;
import org.sonarsource.sonarlint.core.serverapi.system.ServerInfo;
import org.sonarsource.sonarlint.shaded.com.google.gson.Gson;

public class SystemApi {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final ServerApiHelper helper;

    public SystemApi(ServerApiHelper helper) {
        this.helper = helper;
    }

    public CompletableFuture<ServerInfo> getStatus() {
        return ServerApiHelper.processTimed(this.helper.getAsync("api/system/status"), response -> {
            String responseStr = response.bodyAsString();
            try {
                SystemStatus status = new Gson().fromJson(responseStr, SystemStatus.class);
                return new ServerInfo(status.id, status.status, status.version);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to parse server infos from: " + responseStr, e);
            }
        }, duration -> LOG.debug("Downloaded server infos in {}ms", (Object)duration));
    }

    public ServerInfo getStatusSync() {
        try {
            return this.getStatus().get();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get server status", e);
        }
    }

    private static class SystemStatus {
        String id;
        String version;
        String status;

        private SystemStatus() {
        }
    }
}

