/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.util;

import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.serverapi.proto.sonarqube.ws.Common;

public class ServerApiUtils {
    public static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ");

    public static String extractCodeSnippet(String sourceCode, Common.TextRange textRange) {
        return ServerApiUtils.extractCodeSnippet(sourceCode.split("\\r?\\n"), textRange);
    }

    private static String extractCodeSnippet(String[] sourceCodeLines, Common.TextRange textRange) {
        if (textRange.getStartLine() == 0 && textRange.getEndLine() == 0) {
            return String.join((CharSequence)"\n", sourceCodeLines);
        }
        if (textRange.getStartLine() == textRange.getEndLine()) {
            String fullLine = sourceCodeLines[textRange.getStartLine() - 1];
            return fullLine.substring(textRange.getStartOffset(), textRange.getEndOffset());
        }
        CharSequence[] linesOfTextRange = Arrays.copyOfRange(sourceCodeLines, textRange.getStartLine() - 1, textRange.getEndLine());
        linesOfTextRange[0] = linesOfTextRange[0].substring(textRange.getStartOffset());
        linesOfTextRange[linesOfTextRange.length - 1] = linesOfTextRange[linesOfTextRange.length - 1].substring(0, textRange.getEndOffset());
        return String.join((CharSequence)"\n", linesOfTextRange);
    }

    public static boolean isBlank(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isBlank(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    public static boolean areBlank(List<?> ... lists) {
        return Arrays.stream(lists).allMatch(ServerApiUtils::isBlank);
    }

    public static OffsetDateTime parseOffsetDateTime(String s) {
        try {
            return OffsetDateTime.parse(s, DATETIME_FORMATTER);
        }
        catch (DateTimeParseException e) {
            throw new IllegalStateException("The date '" + s + "' does not respect format 'yyyy-MM-dd'T'HH:mm:ssZ'", e);
        }
    }

    private ServerApiUtils() {
    }
}

