/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.NewCodeDefinition;
import org.sonarsource.sonarlint.core.commons.Version;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;
import org.sonarsource.sonarlint.core.serverapi.ServerApi;
import org.sonarsource.sonarlint.core.serverapi.branches.ServerBranch;
import org.sonarsource.sonarlint.core.serverapi.qualityprofile.QualityProfile;
import org.sonarsource.sonarlint.core.serverapi.rules.ServerActiveRule;
import org.sonarsource.sonarlint.core.serverconnection.AnalyzerConfiguration;
import org.sonarsource.sonarlint.core.serverconnection.ConnectionStorage;
import org.sonarsource.sonarlint.core.serverconnection.PluginsSynchronizer;
import org.sonarsource.sonarlint.core.serverconnection.ProjectBranches;
import org.sonarsource.sonarlint.core.serverconnection.RuleSet;
import org.sonarsource.sonarlint.core.serverconnection.ServerConnection;
import org.sonarsource.sonarlint.core.serverconnection.ServerInfoSynchronizer;
import org.sonarsource.sonarlint.core.serverconnection.Settings;
import org.sonarsource.sonarlint.core.serverconnection.SynchronizationResult;
import org.sonarsource.sonarlint.core.serverconnection.storage.StorageException;

public class LocalStorageSynchronizer {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final Set<String> enabledLanguageKeys;
    private final ConnectionStorage storage;
    private final ServerInfoSynchronizer serverInfoSynchronizer;
    private final PluginsSynchronizer pluginsSynchronizer;

    public LocalStorageSynchronizer(Set<Language> enabledLanguages, Set<String> embeddedPluginKeys, ServerInfoSynchronizer serverInfoSynchronizer, ConnectionStorage storage) {
        this.enabledLanguageKeys = enabledLanguages.stream().map(Language::getLanguageKey).collect(Collectors.toSet());
        this.storage = storage;
        this.pluginsSynchronizer = new PluginsSynchronizer(enabledLanguages, storage, embeddedPluginKeys);
        this.serverInfoSynchronizer = serverInfoSynchronizer;
    }

    public SynchronizationResult synchronize(ServerApi serverApi, Set<String> projectKeys, ProgressMonitor progressMonitor) {
        this.serverInfoSynchronizer.synchronize(serverApi);
        Version version = this.storage.serverInfo().read().orElseThrow().getVersion();
        boolean supportsCustomSecrets = !serverApi.isSonarCloud() && version.compareToIgnoreQualifier(ServerConnection.CUSTOM_SECRETS_MIN_SQ_VERSION) >= 0;
        boolean anyPluginUpdated = this.pluginsSynchronizer.synchronize(serverApi, progressMonitor, supportsCustomSecrets);
        projectKeys.stream().collect(Collectors.toMap(Function.identity(), projectKey -> this.synchronizeAnalyzerConfig(serverApi, (String)projectKey, progressMonitor))).forEach((projectKey, analyzerConfig) -> this.storage.project((String)projectKey).analyzerConfiguration().store((AnalyzerConfiguration)analyzerConfig));
        Map branchByProjectKey = projectKeys.stream().collect(Collectors.toMap(Function.identity(), projectKey -> LocalStorageSynchronizer.synchronizeProjectBranches(serverApi, projectKey)));
        branchByProjectKey.forEach((projectKey, branches) -> this.storage.project((String)projectKey).branches().store((ProjectBranches)branches));
        projectKeys.forEach(projectKey -> {
            progressMonitor.checkCancel();
            serverApi.newCodeApi().getNewCodeDefinition((String)projectKey, null, version).ifPresent(ncd -> this.storage.project((String)projectKey).newCodeDefinition().store((NewCodeDefinition)ncd));
        });
        return new SynchronizationResult(anyPluginUpdated);
    }

    private AnalyzerConfiguration synchronizeAnalyzerConfig(ServerApi serverApi, String projectKey, ProgressMonitor progressMonitor) {
        int currentSchemaVersion;
        Map<Object, Object> currentRuleSets;
        LOG.info("[SYNC] Synchronizing analyzer configuration for project '{}'", (Object)projectKey);
        try {
            AnalyzerConfiguration analyzerConfiguration = this.storage.project(projectKey).analyzerConfiguration().read();
            currentRuleSets = analyzerConfiguration.getRuleSetByLanguageKey();
            currentSchemaVersion = analyzerConfiguration.getSchemaVersion();
        }
        catch (StorageException e) {
            currentRuleSets = Map.of();
            currentSchemaVersion = 0;
        }
        boolean shouldForceRuleSetUpdate = LocalStorageSynchronizer.outdatedSchema(currentSchemaVersion);
        Map<Object, Object> currentRuleSetsFinal = currentRuleSets;
        Settings settings = new Settings(serverApi.settings().getProjectSettings(projectKey));
        Map<String, RuleSet> ruleSetsByLanguageKey = serverApi.qualityProfile().getQualityProfiles(projectKey).stream().filter(qualityProfile -> this.enabledLanguageKeys.contains(qualityProfile.getLanguage())).collect(Collectors.toMap(QualityProfile::getLanguage, profile -> LocalStorageSynchronizer.toRuleSet(serverApi, currentRuleSetsFinal, profile, shouldForceRuleSetUpdate, progressMonitor)));
        return new AnalyzerConfiguration(settings, ruleSetsByLanguageKey, 1);
    }

    private static RuleSet toRuleSet(ServerApi serverApi, Map<String, RuleSet> currentRuleSets, QualityProfile profile, boolean forceUpdate, ProgressMonitor progressMonitor) {
        String language = profile.getLanguage();
        if (forceUpdate || LocalStorageSynchronizer.newlySupportedLanguage(currentRuleSets, language) || LocalStorageSynchronizer.profileModifiedSinceLastSync(currentRuleSets, profile, language)) {
            String profileKey = profile.getKey();
            LOG.info("[SYNC] Fetching rule set for language '{}' from profile '{}'", (Object)language, (Object)profileKey);
            Collection<ServerActiveRule> profileActiveRules = serverApi.rules().getAllActiveRules(profileKey, progressMonitor);
            return new RuleSet(profileActiveRules, profile.getRulesUpdatedAt());
        }
        LOG.info("[SYNC] Active rules for '{}' are up-to-date", (Object)language);
        return currentRuleSets.get(language);
    }

    private static boolean profileModifiedSinceLastSync(Map<String, RuleSet> currentRuleSets, QualityProfile profile, String language) {
        return !currentRuleSets.get(language).getLastModified().equals(profile.getRulesUpdatedAt());
    }

    private static boolean newlySupportedLanguage(Map<String, RuleSet> currentRuleSets, String language) {
        return !currentRuleSets.containsKey(language);
    }

    private static boolean outdatedSchema(int currentSchemaVersion) {
        return currentSchemaVersion < 1;
    }

    private static ProjectBranches synchronizeProjectBranches(ServerApi serverApi, String projectKey) {
        LOG.info("[SYNC] Synchronizing project branches for project '{}'", (Object)projectKey);
        List<ServerBranch> allBranches = serverApi.branches().getAllBranches(projectKey);
        String mainBranch = allBranches.stream().filter(ServerBranch::isMain).findFirst().map(ServerBranch::getName).orElseThrow(() -> new IllegalStateException("No main branch for project '" + projectKey + "'"));
        return new ProjectBranches(allBranches.stream().map(ServerBranch::getName).collect(Collectors.toSet()), mainBranch);
    }
}

