/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection.events.issue;

import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.RuleType;
import org.sonarsource.sonarlint.core.serverapi.push.IssueChangedEvent;
import org.sonarsource.sonarlint.core.serverconnection.ConnectionStorage;
import org.sonarsource.sonarlint.core.serverconnection.events.ServerEventHandler;

public class UpdateStorageOnIssueChanged
implements ServerEventHandler<IssueChangedEvent> {
    private final ConnectionStorage storage;

    public UpdateStorageOnIssueChanged(ConnectionStorage storage) {
        this.storage = storage;
    }

    @Override
    public void handle(IssueChangedEvent event) {
        IssueSeverity userSeverity = event.getUserSeverity();
        RuleType userType = event.getUserType();
        Boolean resolved = event.getResolved();
        String projectKey = event.getProjectKey();
        event.getImpactedIssueKeys().forEach(issueKey -> this.update(projectKey, userSeverity, userType, resolved, (String)issueKey));
    }

    private void update(String projectKey, IssueSeverity userSeverity, RuleType userType, Boolean resolved, String issueKey) {
        boolean updated = this.updateNormalIssue(projectKey, userSeverity, userType, resolved, issueKey);
        if (!updated) {
            this.updateTaintIssue(projectKey, userSeverity, userType, resolved, issueKey);
        }
    }

    private boolean updateNormalIssue(String projectKey, IssueSeverity userSeverity, RuleType userType, Boolean resolved, String issueKey) {
        return this.storage.project(projectKey).findings().updateIssue(issueKey, issue -> {
            if (userSeverity != null) {
                issue.setUserSeverity(userSeverity);
            }
            if (userType != null) {
                issue.setType(userType);
            }
            if (resolved != null) {
                issue.setResolved(resolved);
            }
        });
    }

    private void updateTaintIssue(String projectKey, IssueSeverity userSeverity, RuleType userType, Boolean resolved, String issueKey) {
        this.storage.project(projectKey).findings().updateTaintIssue(issueKey, issue -> {
            if (userSeverity != null) {
                issue.setSeverity(userSeverity);
            }
            if (userType != null) {
                issue.setType(userType);
            }
            if (resolved != null) {
                issue.setResolved(resolved);
            }
        });
    }
}

