/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection.storage;

import com.google.protobuf.Message;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.serverconnection.FileUtils;
import org.sonarsource.sonarlint.core.serverconnection.proto.Sonarlint;
import org.sonarsource.sonarlint.core.serverconnection.storage.ProtobufFileUtil;
import org.sonarsource.sonarlint.core.serverconnection.storage.RWLock;

public class SmartNotificationsStorage {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    public static final String LAST_EVENT_POLLING_PB = "last_event_polling.pb";
    private final Path storageFilePath;
    private final RWLock rwLock = new RWLock();

    public SmartNotificationsStorage(Path projectStorageRoot) {
        this.storageFilePath = projectStorageRoot.resolve(LAST_EVENT_POLLING_PB);
    }

    public void store(Long lastEventPolling) {
        FileUtils.mkdirs(this.storageFilePath.getParent());
        Sonarlint.LastEventPolling serverInfoToStore = SmartNotificationsStorage.adapt(lastEventPolling);
        LOG.debug("Storing last event polling in {}", (Object)this.storageFilePath);
        this.rwLock.write(() -> ProtobufFileUtil.writeToFile((Message)serverInfoToStore, this.storageFilePath));
    }

    public Optional<Long> readLastEventPolling() {
        return this.rwLock.read(() -> Files.exists(this.storageFilePath, new LinkOption[0]) ? Optional.of(SmartNotificationsStorage.adapt(ProtobufFileUtil.readFile(this.storageFilePath, Sonarlint.LastEventPolling.parser()))) : Optional.empty());
    }

    private static Sonarlint.LastEventPolling adapt(Long lastEventPolling) {
        return Sonarlint.LastEventPolling.newBuilder().setLastEventPolling(lastEventPolling).build();
    }

    private static Long adapt(Sonarlint.LastEventPolling lastEventPolling) {
        return lastEventPolling.getLastEventPolling();
    }
}

