/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.model;

import java.io.File;
import org.conqat.lib.simulink.model.datahandler.ModelDataHandler;

public class ReferencedBlockInfo {
    private static final String[] TESTED_EXTENSIONS = new String[]{"", ".mdl", ".slx"};
    private final String modelName;
    private final String blockName;
    private final File modelFile;
    private final boolean subsystemReference;

    ReferencedBlockInfo(String modelName, String blockName, ModelDataHandler modelDataHandler) {
        this(modelName, blockName, modelDataHandler, false);
    }

    ReferencedBlockInfo(String modelName, String blockName, ModelDataHandler modelDataHandler, boolean subsystemReference) {
        this.modelName = modelName;
        this.blockName = blockName;
        this.modelFile = ReferencedBlockInfo.locateModelFile(modelName, modelDataHandler);
        this.subsystemReference = subsystemReference;
    }

    private static File locateModelFile(String modelName, ModelDataHandler modelDataHandler) {
        for (File basePath : modelDataHandler.getReferenceDirectories()) {
            for (String extension : TESTED_EXTENSIONS) {
                File modelFile = new File(basePath, modelName + extension);
                if (!modelFile.isFile()) continue;
                return modelFile;
            }
        }
        return null;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getBlockName() {
        return this.blockName;
    }

    public File getModelFile() {
        return this.modelFile;
    }

    public boolean isModelFileFound() {
        return this.modelFile != null;
    }

    public boolean isSubsystemReference() {
        return this.subsystemReference;
    }
}

