/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.teamfoundation.build.webapi;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.alm.teamfoundation.build.webapi.BuildTrigger;
import com.microsoft.alm.teamfoundation.build.webapi.ContinuousIntegrationTrigger;
import com.microsoft.alm.teamfoundation.build.webapi.DefinitionTriggerType;
import com.microsoft.alm.teamfoundation.build.webapi.ScheduleTrigger;
import java.io.IOException;

public class BuildTriggerDeserializer
extends JsonDeserializer<BuildTrigger> {
    public BuildTrigger deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)parser.getCodec();
        JsonNode rootNode = (JsonNode)mapper.readTree(parser);
        JsonNode typeNode = rootNode.findValue("TriggerType");
        if (typeNode != null) {
            DefinitionTriggerType triggerType = null;
            if (typeNode.isInt() && typeNode.asInt() == DefinitionTriggerType.CONTINUOUS_INTEGRATION.getValue()) {
                triggerType = DefinitionTriggerType.CONTINUOUS_INTEGRATION;
            } else if (typeNode.isInt() && typeNode.asInt() == DefinitionTriggerType.SCHEDULE.getValue()) {
                triggerType = DefinitionTriggerType.SCHEDULE;
            } else if (typeNode.isTextual() && DefinitionTriggerType.CONTINUOUS_INTEGRATION.toString().equalsIgnoreCase(typeNode.asText())) {
                triggerType = DefinitionTriggerType.CONTINUOUS_INTEGRATION;
            } else if (typeNode.isTextual() && DefinitionTriggerType.SCHEDULE.toString().equalsIgnoreCase(typeNode.asText())) {
                triggerType = DefinitionTriggerType.SCHEDULE;
            }
            if (DefinitionTriggerType.SCHEDULE == triggerType) {
                return (BuildTrigger)rootNode.traverse((ObjectCodec)mapper).readValueAs(ScheduleTrigger.class);
            }
            if (DefinitionTriggerType.CONTINUOUS_INTEGRATION == triggerType) {
                return (BuildTrigger)rootNode.traverse((ObjectCodec)mapper).readValueAs(ContinuousIntegrationTrigger.class);
            }
        }
        return null;
    }
}

