/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.clients.build.IBuildController;
import com.microsoft.tfs.core.clients.build.IBuildDefinition;
import com.microsoft.tfs.core.clients.build.IBuildRequest;
import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.flags.BuildReason;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDefinition;
import com.microsoft.tfs.core.clients.build.soapextensions.GetOption;
import com.microsoft.tfs.core.clients.build.soapextensions.QueuePriority;
import com.microsoft.tfs.core.clients.versioncontrol.specs.WorkspaceSpec;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.StringUtil;
import ms.tfs.build.buildservice._04._BuildRequest;

public class BuildRequest
extends WebServiceObjectWrapper
implements IBuildRequest {
    private IBuildController buildController;
    private IBuildDefinition buildDefinition;
    private IBuildServer buildServer;

    private BuildRequest() {
        super(new _BuildRequest());
    }

    public BuildRequest(BuildDefinition definition) {
        this();
        this.setBuildDefinition(definition);
        this.setBuildServer(definition.getBuildServer());
        this.setBuildController(definition.getBuildController());
        this.getWebServiceObject().setDropLocation(definition.getDefaultDropLocation());
        this.getWebServiceObject().setProcessParameters(null);
    }

    public BuildRequest(IBuildServer buildServer, String buildDefinitionUri, String buildControllerUri) {
        this();
        this.setBuildServer(buildServer);
        this.getWebServiceObject().setBuildDefinitionUri(buildDefinitionUri);
        this.getWebServiceObject().setBuildControllerUri(buildControllerUri);
    }

    public _BuildRequest getWebServiceObject() {
        return (_BuildRequest)this.webServiceObject;
    }

    @Override
    public IBuildController getBuildController() {
        return this.buildController;
    }

    @Override
    public void setBuildController(IBuildController value) {
        this.buildController = value;
        if (this.buildController == null) {
            this.getWebServiceObject().setBuildControllerUri(null);
        } else {
            this.getWebServiceObject().setBuildControllerUri(this.buildController.getURI());
        }
    }

    @Override
    public IBuildDefinition getBuildDefinition() {
        return this.buildDefinition;
    }

    public void setBuildDefinition(IBuildDefinition value) {
        this.buildDefinition = value;
        if (this.buildDefinition == null) {
            this.getWebServiceObject().setBuildDefinitionUri(null);
        } else {
            this.getWebServiceObject().setBuildDefinitionUri(value.getURI());
        }
    }

    @Override
    public IBuildServer getBuildServer() {
        return this.buildServer;
    }

    private void setBuildServer(IBuildServer value) {
        this.buildServer = value;
    }

    @Override
    public GUID getBatchID() {
        return new GUID(this.getWebServiceObject().getBatchId());
    }

    @Override
    public void setBatchID(GUID value) {
        this.getWebServiceObject().setBatchId(value.getGUIDString(GUID.GUIDStringFormat.NONE));
    }

    @Override
    public String getBuildControllerURI() {
        return this.getWebServiceObject().getBuildControllerUri();
    }

    public void setBuildControllerURI(String value) {
        this.getWebServiceObject().setBuildControllerUri(value);
    }

    @Override
    public String getBuildDefinitionURI() {
        return this.getWebServiceObject().getBuildDefinitionUri();
    }

    @Override
    public void setBuildDefinitionURI(String value) {
        this.getWebServiceObject().setBuildDefinitionUri(value);
    }

    @Override
    public String getCustomGetVersion() {
        return this.getWebServiceObject().getCustomGetVersion();
    }

    @Override
    public void setCustomGetVersion(String value) {
        this.getWebServiceObject().setCustomGetVersion(value);
    }

    @Override
    public String getDropLocation() {
        return this.getWebServiceObject().getDropLocation();
    }

    @Override
    public void setDropLocation(String value) {
        this.getWebServiceObject().setDropLocation(value);
    }

    @Override
    public String getGatedCheckInTicket() {
        return this.getWebServiceObject().getCheckInTicket();
    }

    @Override
    public void setGatedCheckInTicket(String value) {
        this.getWebServiceObject().setCheckInTicket(value);
    }

    @Override
    public GetOption getGetOption() {
        return GetOption.fromWebServiceObject(this.getWebServiceObject().getGetOption());
    }

    @Override
    public void setGetOption(GetOption value) {
        this.getWebServiceObject().setGetOption(value.getWebServiceObject());
    }

    @Override
    public int getMaxQueuePosition() {
        return this.getWebServiceObject().getMaxQueuePosition();
    }

    @Override
    public void setMaxQueuePosition(int value) {
        this.getWebServiceObject().setMaxQueuePosition(value);
    }

    @Override
    public boolean isPostponed() {
        return this.getWebServiceObject().isPostponed();
    }

    @Override
    public void setPostponed(boolean value) {
        this.getWebServiceObject().setPostponed(value);
    }

    @Override
    public QueuePriority getPriority() {
        return QueuePriority.fromWebServiceObject(this.getWebServiceObject().getPriority());
    }

    @Override
    public void setPriority(QueuePriority value) {
        this.getWebServiceObject().setPriority(value.getWebServiceObject());
    }

    @Override
    public String getProcessParameters() {
        return this.getWebServiceObject().getProcessParameters();
    }

    @Override
    public void setProcessParameters(String value) {
        this.getWebServiceObject().setProcessParameters(value);
    }

    @Override
    public BuildReason getReason() {
        return BuildReason.fromWebServiceObject(this.getWebServiceObject().getReason());
    }

    @Override
    public void setReason(BuildReason value) {
        this.getWebServiceObject().setReason(value.getWebServiceObject());
    }

    @Override
    public String getRequestedFor() {
        return this.getWebServiceObject().getRequestedFor();
    }

    @Override
    public void setRequestedFor(String value) {
        this.getWebServiceObject().setRequestedFor(value);
    }

    @Override
    public String getShelvesetName() {
        return this.getWebServiceObject().getShelvesetName();
    }

    @Override
    public void setShelvesetName(String value) {
        this.getWebServiceObject().setShelvesetName(value);
    }

    public void beforeSerialize() {
        if (!StringUtil.isNullOrEmpty(this.getShelvesetName())) {
            WorkspaceSpec spec = WorkspaceSpec.parse(this.getShelvesetName(), this.buildServer.getConnection().getAuthorizedIdentity().getUniqueName());
            this.setShelvesetName(spec.toString());
        }
    }
}

