/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build.internal.soapextensions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.build.IBuildController;
import com.microsoft.tfs.core.clients.build.IBuildDefinition;
import com.microsoft.tfs.core.clients.build.IBuildDetail;
import com.microsoft.tfs.core.clients.build.IBuildServer;
import com.microsoft.tfs.core.clients.build.IQueuedBuild;
import com.microsoft.tfs.core.clients.build.exceptions.QueuedBuildDoesNotExistException;
import com.microsoft.tfs.core.clients.build.flags.BuildReason;
import com.microsoft.tfs.core.clients.build.flags.BuildStatus;
import com.microsoft.tfs.core.clients.build.flags.QueryOptions;
import com.microsoft.tfs.core.clients.build.flags.QueueStatus;
import com.microsoft.tfs.core.clients.build.flags.QueuedBuildRetryOption;
import com.microsoft.tfs.core.clients.build.flags.QueuedBuildUpdate;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildDetail;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildQueueQueryResult;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.BuildServer;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.QueuedBuild2008;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.QueuedBuild2010;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.QueuedBuildUpdateOptions;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.TFS2008Helper;
import com.microsoft.tfs.core.clients.build.internal.soapextensions.TFS2010Helper;
import com.microsoft.tfs.core.clients.build.soapextensions.GetOption;
import com.microsoft.tfs.core.clients.build.soapextensions.QueuePriority;
import com.microsoft.tfs.core.exceptions.NotSupportedException;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.util.GUID;
import com.microsoft.tfs.util.StringUtil;
import com.microsoft.tfs.util.datetime.DotNETDate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import ms.tfs.build.buildservice._04._QueuedBuild;

public class QueuedBuild
extends WebServiceObjectWrapper
implements IQueuedBuild {
    private IBuildController buildController;
    private IBuildDefinition buildDefinition;
    private BuildServer buildServer;
    private QueuedBuildUpdateOptions lastSnapshot;
    private boolean postponed;
    private boolean retry;
    private QueuedBuildRetryOption retryOption = QueuedBuildRetryOption.NONE;
    private BuildDetail build;
    private List<IBuildDetail> allBuilds = new ArrayList<IBuildDetail>();

    private QueuedBuild(IBuildServer buildServer) {
        super(new _QueuedBuild());
        this.buildServer = (BuildServer)buildServer;
        _QueuedBuild _o = this.getWebServiceObject();
        _o.setBuildUris(new String[0]);
        _o.setGetOption(GetOption.LATEST_ON_BUILD.getWebServiceObject());
        _o.setPriority(QueuePriority.NORMAL.getWebServiceObject());
        _o.setQueueTime(DotNETDate.MIN_CALENDAR);
        _o.setReason(BuildReason.MANUAL.getWebServiceObject());
        _o.setStatus(QueueStatus.NONE.getWebServiceObject());
    }

    public QueuedBuild(IBuildServer buildServer, _QueuedBuild webSerivceObject) {
        super(webSerivceObject);
        this.buildServer = (BuildServer)buildServer;
        this.afterDeserialize();
    }

    public QueuedBuild(IBuildServer buildServer, QueuedBuild2010 build2010) {
        this(buildServer);
        _QueuedBuild qb = this.getWebServiceObject();
        qb.setBuildControllerUri(build2010.getBuildControllerUri());
        qb.setBuildDefinitionUri(build2010.getBuildDefinitionUri());
        if (build2010.getBuild() != null) {
            BuildDetail currentBuild;
            this.build = currentBuild = TFS2010Helper.convert(buildServer, build2010.getBuild());
            this.allBuilds.add(currentBuild);
            qb.setBuildUris(new String[]{currentBuild.getURI()});
        }
        qb.setCustomGetVersion(build2010.getCustomGetVersion());
        qb.setDropLocation(build2010.getDropLocation());
        qb.setGetOption(TFS2010Helper.convert(build2010.getGetOption()).getWebServiceObject());
        qb.setId(build2010.getID());
        qb.setPriority(TFS2010Helper.convert(build2010.getPriority()).getWebServiceObject());
        qb.setProcessParameters(build2010.getProcessParameters());
        qb.setQueuePosition(build2010.getQueuePosition());
        qb.setQueueTime(build2010.getQueueTime());
        qb.setReason(TFS2010Helper.convert(build2010.getReason()).getWebServiceObject());
        qb.setRequestedBy(build2010.getRequestedBy());
        qb.setRequestedFor(build2010.getRequestedFor());
        qb.setShelvesetName(build2010.getShelvesetName());
        qb.setStatus(TFS2010Helper.convert(build2010.getStatus()).getWebServiceObject());
        qb.setTeamProject(build2010.getTeamProject());
        this.afterDeserialize();
    }

    public QueuedBuild(BuildServer buildServer, QueuedBuild2008 build2008) {
        this(buildServer);
        this.setBuildControllerURI(build2008.getBuildAgentURI());
        this.setBuildDefinitionURI(build2008.getBuildDefinitionURI());
        this.getWebServiceObject().setId(build2008.getID());
        this.setPriority(TFS2010Helper.convert(build2008.getPriority()));
        this.setQueuePosition(build2008.getQueuePosition());
        this.getWebServiceObject().setQueueTime(build2008.getQueueTime());
        this.getWebServiceObject().setRequestedBy(build2008.getRequestedBy());
        this.getWebServiceObject().setRequestedFor(build2008.getRequestedFor());
        this.setStatus(TFS2010Helper.convert(build2008.getStatus()));
        BuildDetail build = TFS2008Helper.convert(buildServer, build2008.getBuild());
        if (build != null) {
            this.build = build;
            this.allBuilds.add(this.build);
            this.getWebServiceObject().setBuildUris(new String[]{this.build.getURI()});
        }
        this.afterDeserialize();
    }

    public QueuedBuild(IBuildServer buildServer, BuildDetail build) {
        this(buildServer);
        _QueuedBuild qb = this.getWebServiceObject();
        qb.setBuildControllerUri(build.getBuildControllerURI());
        this.buildServer = (BuildServer)build.getBuildServer();
        qb.setBuildDefinitionUri(build.getBuildDefinitionURI());
        qb.setDropLocation(build.getDropLocation());
        qb.setId(0);
        qb.setPriority(QueuePriority.NORMAL.getWebServiceObject());
        qb.setQueuePosition(1);
        qb.setQueueTime(build.getStartTime());
        qb.setReason(build.getReason().getWebServiceObject());
        qb.setRequestedBy(build.getRequestedBy());
        qb.setRequestedFor(build.getRequestedFor());
        qb.setShelvesetName(build.getShelvesetName());
        qb.setTeamProject(build.getTeamProject());
        if (build.getStatus().equals(BuildStatus.IN_PROGRESS)) {
            qb.setStatus(QueueStatus.IN_PROGRESS.getWebServiceObject());
        } else {
            qb.setStatus(QueueStatus.COMPLETED.getWebServiceObject());
        }
        this.allBuilds.add(build);
        qb.setBuildUris(new String[]{build.getURI()});
        this.afterDeserialize();
    }

    private void afterDeserialize() {
        this.postponed = this.getStatus().equals(QueueStatus.POSTPONED);
        this.lastSnapshot = this.getSnapshot();
        if (StringUtil.isNullOrEmpty(this.getRequestedByDisplayName())) {
            this.getWebServiceObject().setRequestedByDisplayName(this.getRequestedBy());
        }
        if (StringUtil.isNullOrEmpty(this.getRequestedForDisplayName())) {
            this.getWebServiceObject().setRequestedForDisplayName(this.getRequestedFor());
        }
        if (this.getBuildURIs() == null) {
            this.getWebServiceObject().setBuildUris(new String[0]);
        }
    }

    public _QueuedBuild getWebServiceObject() {
        return (_QueuedBuild)this.webServiceObject;
    }

    public String[] getBuildURIs() {
        return this.getWebServiceObject().getBuildUris();
    }

    @Override
    public GUID getBatchID() {
        return new GUID(this.getWebServiceObject().getBatchId());
    }

    @Override
    public String getBuildControllerURI() {
        return this.getWebServiceObject().getBuildControllerUri();
    }

    public void setBuildControllerURI(String value) {
        this.getWebServiceObject().setBuildControllerUri(value);
    }

    @Override
    public String getBuildDefinitionURI() {
        return this.getWebServiceObject().getBuildDefinitionUri();
    }

    public void setBuildDefinitionURI(String value) {
        this.getWebServiceObject().setBuildDefinitionUri(value);
    }

    @Override
    public String getCustomGetVersion() {
        return this.getWebServiceObject().getCustomGetVersion();
    }

    @Override
    public String getDropLocation() {
        return this.getWebServiceObject().getDropLocation();
    }

    @Override
    public GetOption getGetOption() {
        return GetOption.fromWebServiceObject(this.getWebServiceObject().getGetOption());
    }

    @Override
    public int getID() {
        return this.getWebServiceObject().getId();
    }

    @Override
    public QueuePriority getPriority() {
        return QueuePriority.fromWebServiceObject(this.getWebServiceObject().getPriority());
    }

    @Override
    public void setPriority(QueuePriority value) {
        this.getWebServiceObject().setPriority(value.getWebServiceObject());
    }

    @Override
    public String getProcessParameters() {
        return this.getWebServiceObject().getProcessParameters();
    }

    @Override
    public int getQueuePosition() {
        return this.getWebServiceObject().getQueuePosition();
    }

    public void setQueuePosition(int value) {
        this.getWebServiceObject().setQueuePosition(value);
    }

    @Override
    public Calendar getQueueTime() {
        return this.getWebServiceObject().getQueueTime();
    }

    @Override
    public BuildReason getReason() {
        return BuildReason.fromWebServiceObject(this.getWebServiceObject().getReason());
    }

    public void setReason(BuildReason value) {
        this.getWebServiceObject().setReason(value.getWebServiceObject());
    }

    @Override
    public String getRequestedBy() {
        return this.getWebServiceObject().getRequestedBy();
    }

    @Override
    public String getRequestedByDisplayName() {
        return this.getWebServiceObject().getRequestedByDisplayName();
    }

    @Override
    public String getRequestedFor() {
        return this.getWebServiceObject().getRequestedFor();
    }

    @Override
    public String getRequestedForDisplayName() {
        return this.getWebServiceObject().getRequestedForDisplayName();
    }

    @Override
    public String getShelvesetName() {
        return this.getWebServiceObject().getShelvesetName();
    }

    @Override
    public QueueStatus getStatus() {
        return QueueStatus.fromWebServiceObject(this.getWebServiceObject().getStatus());
    }

    public void setStatus(QueueStatus value) {
        this.getWebServiceObject().setStatus(value.getWebServiceObject());
    }

    @Override
    public String getTeamProject() {
        return this.getWebServiceObject().getTeamProject();
    }

    public List<IBuildDetail> getAllBuilds() {
        return this.allBuilds;
    }

    @Override
    public List<IBuildDetail> getBuilds() {
        return this.allBuilds;
    }

    @Override
    public IBuildDetail getBuild() {
        if (this.allBuilds.size() > 0) {
            return this.allBuilds.get(this.allBuilds.size() - 1);
        }
        return null;
    }

    @Override
    public IBuildController getBuildController() {
        return this.buildController;
    }

    public void setBuildController(IBuildController value) {
        this.buildController = value;
    }

    @Override
    public IBuildDefinition getBuildDefinition() {
        return this.buildDefinition;
    }

    public void setBuildDefinition(IBuildDefinition value) {
        this.buildDefinition = value;
        if (this.buildDefinition != null && StringUtil.isNullOrEmpty(this.getTeamProject())) {
            this.getWebServiceObject().setTeamProject(this.buildDefinition.getTeamProject());
        }
    }

    @Override
    public IBuildServer getBuildServer() {
        return this.buildServer;
    }

    public void setBuildServer(IBuildServer value) {
        this.buildServer = (BuildServer)value;
    }

    @Override
    public void cancel() {
        this.getBuildServer().cancelBuilds(new int[]{this.getID()});
    }

    @Override
    public void postpone() {
        this.postponed = true;
    }

    @Override
    public void refresh(QueryOptions queryOptions) {
        BuildQueueQueryResult result = this.buildServer.getBuildServerVersion().isV2() ? this.buildServer.getBuild2008Helper().queryQueuedBuildsById(new int[]{this.getID()}, queryOptions) : (this.buildServer.getBuildServerVersion().isV3() ? this.buildServer.getBuild2010Helper().queryQueuedBuildsById(new int[]{this.getID()}, queryOptions) : this.buildServer.getBuildQueueService().queryBuildsById(new int[]{this.getID()}, null, queryOptions));
        IQueuedBuild[] queuedBuilds = result.getQueuedBuilds();
        if (queuedBuilds.length == 0 || queuedBuilds[0] == null) {
            String format = Messages.getString("QueuedBuild2012.DoesNotExistFormat");
            String message = MessageFormat.format(format, this.getID());
            throw new QueuedBuildDoesNotExistException(message);
        }
        this.copy(result.getQueuedBuilds()[0], queryOptions);
    }

    @Override
    public void resume() {
        this.postponed = false;
    }

    @Override
    public void retry() {
        this.retry(GUID.newGUID());
    }

    @Override
    public void retry(GUID batchId) {
        this.retry(batchId, QueuedBuildRetryOption.IN_PROGRESS_BUILD);
        this.retry = true;
    }

    @Override
    public void retry(GUID batchId, QueuedBuildRetryOption retryOption) {
        if (this.buildServer.getBuildServerVersion().isLessThanV4()) {
            String format = Messages.getString("QueuedBuild2012.MethodNotSupportedFormat");
            String message = MessageFormat.format(format, "Retry", "IQueuedBuild");
            throw new NotSupportedException(message);
        }
        if (retryOption == QueuedBuildRetryOption.NONE) {
            String format = Messages.getString("QueuedBuild2012.InvalidArgumentFormat");
            String message = MessageFormat.format(format, QueuedBuildRetryOption.NONE.toString());
            throw new IllegalArgumentException(message);
        }
        this.retryOption = retryOption;
        this.getWebServiceObject().setBatchId(batchId.getGUIDString(GUID.GUIDStringFormat.NONE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        QueuedBuildUpdateOptions queuedBuildUpdateOptions = this.lastSnapshot;
        synchronized (queuedBuildUpdateOptions) {
            QueuedBuildUpdateOptions currentSnapshot = this.getSnapshot();
            currentSnapshot.setFields(this.compareSnapshots(this.lastSnapshot, currentSnapshot));
            if (currentSnapshot.getFields() != QueuedBuildUpdate.NONE) {
                IQueuedBuild[] results = this.buildServer.getBuildServerVersion().isV2() ? this.buildServer.getBuild2008Helper().updateQueuedBuilds(new QueuedBuildUpdateOptions[]{currentSnapshot}) : (this.buildServer.getBuildServerVersion().isV3() ? this.buildServer.getBuild2010Helper().updateQueuedBuilds(new QueuedBuildUpdateOptions[]{currentSnapshot}) : this.buildServer.getBuildQueueService().updateBuilds(new QueuedBuildUpdateOptions[]{currentSnapshot}).getQueuedBuilds());
                this.copy(results[0], QueryOptions.NONE);
            }
            this.lastSnapshot = currentSnapshot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueuedBuildUpdateOptions getUpdateOptions() {
        QueuedBuildUpdateOptions currentSnapshot;
        QueuedBuildUpdateOptions queuedBuildUpdateOptions = this.lastSnapshot;
        synchronized (queuedBuildUpdateOptions) {
            currentSnapshot = this.getSnapshot();
            currentSnapshot.setFields(this.compareSnapshots(this.lastSnapshot, currentSnapshot));
        }
        return currentSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpdateOptions(QueuedBuildUpdateOptions snapshot) {
        QueuedBuildUpdateOptions queuedBuildUpdateOptions = this.lastSnapshot;
        synchronized (queuedBuildUpdateOptions) {
            this.lastSnapshot = snapshot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean copy(IQueuedBuild build, QueryOptions queryOptions) {
        boolean changed = !this.getPriority().equals(build.getPriority()) || this.getQueuePosition() != build.getQueuePosition() || !this.getStatus().equals(build.getStatus());
        QueuedBuildUpdateOptions queuedBuildUpdateOptions = this.lastSnapshot;
        synchronized (queuedBuildUpdateOptions) {
            this.allBuilds = new ArrayList<IBuildDetail>(build.getBuilds());
            this.getWebServiceObject().setBatchId(build.getBatchID().getGUIDString(GUID.GUIDStringFormat.NONE));
            this.getWebServiceObject().setBuildUris(((QueuedBuild)build).getBuildURIs());
            this.getWebServiceObject().setPriority(build.getPriority().getWebServiceObject());
            this.getWebServiceObject().setQueuePosition(build.getQueuePosition());
            this.getWebServiceObject().setStatus(build.getStatus().getWebServiceObject());
            this.postponed = this.getStatus().equals(QueueStatus.POSTPONED);
            this.retry = this.getStatus().equals(QueueStatus.RETRY);
            this.retryOption = ((QueuedBuild)build).retryOption;
            this.getWebServiceObject().setQueueTime(build.getQueueTime());
            if (queryOptions.contains(QueryOptions.DEFINITIONS)) {
                this.setBuildDefinition(build.getBuildDefinition());
            }
            this.lastSnapshot = this.getSnapshot();
        }
        return changed;
    }

    private QueuedBuildUpdateOptions getSnapshot() {
        QueuedBuildUpdateOptions result = new QueuedBuildUpdateOptions();
        result.setQueueID(this.getID());
        result.setPostponed(this.postponed);
        result.setPriority(this.getPriority());
        result.setBatchID(this.getBatchID());
        result.setRetry(this.retry);
        result.setRetryOption(this.retryOption);
        return result;
    }

    private QueuedBuildUpdate compareSnapshots(QueuedBuildUpdateOptions originalValues, QueuedBuildUpdateOptions modifiedValues) {
        QueuedBuildUpdate result = QueuedBuildUpdate.NONE;
        if (!originalValues.getBatchID().equals(modifiedValues.getBatchID())) {
            result = result.combine(QueuedBuildUpdate.BATCHID);
        }
        if (originalValues.isPostponed() != modifiedValues.isPostponed()) {
            result = result.combine(QueuedBuildUpdate.POSTPONED);
        }
        if (!originalValues.getPriority().equals(modifiedValues.getPriority())) {
            result = result.combine(QueuedBuildUpdate.PRIORITY);
        }
        if (originalValues.isRetry() != modifiedValues.isRetry()) {
            result = result.combine(QueuedBuildUpdate.RETRY);
        }
        if (!originalValues.getRetryOption().equals(modifiedValues.getRetryOption())) {
            result = result.combine(QueuedBuildUpdate.REQUEUE);
        }
        return result;
    }

    @Override
    public int compareTo(QueuedBuild build) {
        return this.compareTo((IQueuedBuild)build);
    }

    @Override
    public int compareTo(IQueuedBuild build) {
        int result;
        if (this.getQueuePosition() > 0 && build.getQueuePosition() > 0) {
            result = 0;
            if (this.getStatus().toIntFlags() > build.getStatus().toIntFlags()) {
                result = 1;
            } else if (this.getStatus().toIntFlags() < build.getStatus().toIntFlags()) {
                result = -1;
            }
            if (result == 0) {
                result = this.getPriority().compareTo(build.getPriority());
            }
        } else {
            result = new Integer(this.getQueuePosition()).compareTo(build.getQueuePosition());
        }
        if (result == 0 && (result = this.getBuild() != null && build.getBuild() != null ? this.getBuild().getFinishTime().compareTo(build.getBuild().getFinishTime()) : this.getQueueTime().compareTo(build.getQueueTime())) == 0) {
            result = new Integer(this.getID()).compareTo(build.getID());
        }
        return result;
    }
}

