/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.configuration.catalog;

import com.microsoft.tfs.core.clients.framework.catalog.CatalogNode;
import com.microsoft.tfs.core.clients.framework.configuration.catalog.TFSCatalogEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.OrganizationalRootEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ProjectCollectionEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ReportingConfigurationEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ReportingFolderEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.TeamProjectEntity;
import com.microsoft.tfs.core.clients.framework.configuration.internal.TFSCatalogEntitySession;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;

public class ProjectCollectionCatalogEntity
extends TFSCatalogEntity
implements ProjectCollectionEntity {
    public ProjectCollectionCatalogEntity(TFSCatalogEntitySession session, CatalogNode catalogNode) {
        super(session, catalogNode);
    }

    @Override
    public GUID getInstanceID() {
        String instanceId = this.getProperty("InstanceId");
        if (instanceId == null) {
            return null;
        }
        return new GUID(instanceId);
    }

    @Override
    public TeamProjectEntity[] getTeamProjects() {
        return (TeamProjectEntity[])this.getChildrenOfType(TeamProjectEntity.class);
    }

    @Override
    public TeamProjectEntity getTeamProject(GUID projectId) {
        Check.notNull(projectId, "projectId");
        TeamProjectEntity[] projects = this.getTeamProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (!projectId.equals(projects[i].getProjectID())) continue;
            return projects[i];
        }
        return null;
    }

    @Override
    public ReportingConfigurationEntity getReportingConfiguration() {
        OrganizationalRootEntity organizationalRoot = this.getAncestorOfType(OrganizationalRootEntity.class);
        if (organizationalRoot == null) {
            return null;
        }
        return organizationalRoot.getReportingConfiguration();
    }

    @Override
    public ReportingFolderEntity getReportingFolder() {
        return this.getChildOfType(ReportingFolderEntity.class);
    }
}

