/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.framework.configuration.compatibility;

import com.microsoft.tfs.core.clients.commonstructure.ProjectInfo;
import com.microsoft.tfs.core.clients.framework.catalog.CatalogResourceTypes;
import com.microsoft.tfs.core.clients.framework.configuration.compatibility.ProjectPortalCompatibilityEntity;
import com.microsoft.tfs.core.clients.framework.configuration.compatibility.ReportingFolderCompatibilityEntity;
import com.microsoft.tfs.core.clients.framework.configuration.compatibility.TFSCompatibilityEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ProcessGuidanceEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ProjectPortalEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ReportingFolderEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.TeamProjectEntity;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;

public class TeamProjectCompatibilityEntity
extends TFSCompatibilityEntity
implements TeamProjectEntity {
    private final ProjectInfo projectInfo;
    private final Object lock = new Object();
    private ProjectPortalEntity projectPortal;
    private ReportingFolderEntity reportingFolder;

    public TeamProjectCompatibilityEntity(TFSCompatibilityEntity parent, ProjectInfo projectInfo) {
        super(parent);
        Check.notNull(projectInfo, "projectInfo");
        this.projectInfo = projectInfo;
    }

    @Override
    public GUID getResourceID() {
        return CatalogResourceTypes.TEAM_PROJECT;
    }

    @Override
    public String getDisplayName() {
        return this.getProjectName();
    }

    @Override
    public GUID getProjectID() {
        return new GUID(this.projectInfo.getGUID());
    }

    @Override
    public String getProjectName() {
        return this.projectInfo.getName();
    }

    @Override
    public String getProjectURI() {
        return this.projectInfo.getURI();
    }

    @Override
    public ProcessGuidanceEntity getProcessGuidance() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectPortalEntity getProjectPortal() {
        Object object = this.lock;
        synchronized (object) {
            if (this.projectPortal == null) {
                this.projectPortal = new ProjectPortalCompatibilityEntity(this, this.projectInfo.getName());
            }
            return this.projectPortal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReportingFolderEntity getReportingFolder() {
        Object object = this.lock;
        synchronized (object) {
            if (this.reportingFolder == null) {
                this.reportingFolder = new ReportingFolderCompatibilityEntity(this, this.projectInfo.getName());
            }
            return this.reportingFolder;
        }
    }
}

