/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.team;

import com.microsoft.tfs.core.TFSConnection;
import com.microsoft.tfs.core.clients.webservices.IIdentityManagementService2;
import com.microsoft.tfs.core.clients.webservices.IdentityDescriptor;
import com.microsoft.tfs.core.clients.webservices.IdentityPropertyScope;
import com.microsoft.tfs.core.clients.webservices.MembershipQuery;
import com.microsoft.tfs.core.clients.webservices.ReadIdentityOptions;
import com.microsoft.tfs.core.clients.webservices.TeamFoundationIdentity;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class TeamFoundationTeam {
    private TeamFoundationIdentity identity;

    public TeamFoundationTeam(TeamFoundationIdentity team) {
        AtomicReference<Object> val = new AtomicReference<Object>();
        if (!team.tryGetProperty("Microsoft.TeamFoundation.Team", val)) {
            throw new RuntimeException(MessageFormat.format("The TeamFoundationIdentity object is missing the required ''{0}'' property", "Microsoft.TeamFoundation.Team"));
        }
        this.identity = team;
    }

    public TeamFoundationIdentity getIdentity() {
        return this.identity;
    }

    public void setIdentity(TeamFoundationIdentity identity) {
        this.identity = identity;
    }

    public String getProject() {
        return this.identity.getAttribute("Domain", null);
    }

    public String getName() {
        return this.identity.getAttribute("Account", null);
    }

    public void setName(String name) {
        this.identity.setAttribute("Account", name);
    }

    public String getDescription() {
        return this.identity.getAttribute("Description", null);
    }

    public void setDescription(String name) {
        this.identity.setAttribute("Description", name);
    }

    public boolean tryGetProperty(String name, AtomicReference<Object> value) {
        return this.identity.tryGetProperty(name, value);
    }

    public Object getProperty(String name) {
        return this.identity.getProperty(name);
    }

    public void removeProperty(String name) {
        this.setProperty(name, null);
    }

    public Iterable<Map.Entry<String, Object>> GetProperties() {
        return this.identity.getProperties();
    }

    public void setProperty(String name, Object value) {
        this.identity.setProperty(IdentityPropertyScope.LOCAL, name, value);
    }

    public TeamFoundationIdentity[] getMembers(TFSConnection connection, MembershipQuery queryMembership) {
        IIdentityManagementService2 identitySvc = (IIdentityManagementService2)connection.getClient(IIdentityManagementService2.class);
        TeamFoundationIdentity teamIdentity = identitySvc.readIdentities(new IdentityDescriptor[]{this.identity.getDescriptor()}, queryMembership, ReadIdentityOptions.NONE, null, IdentityPropertyScope.NONE)[0];
        TeamFoundationIdentity[] results = teamIdentity != null ? identitySvc.readIdentities(teamIdentity.getMembers(), MembershipQuery.NONE, ReadIdentityOptions.NONE) : new TeamFoundationIdentity[]{};
        return results;
    }
}

