/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.conflicts;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.MergeSummary;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictCategory;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictDescriptionStrings;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolution;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolutionOptions;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.CoreConflictResolution;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.contributors.ConflictResolutionContributor;
import com.microsoft.tfs.core.clients.versioncontrol.engines.MergeEngine;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Resolution;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.util.FileEncoding;
import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;
import java.util.ArrayList;

public class VersionConflictDescription
extends ConflictDescription {
    private boolean hasAnalyzed = false;

    protected VersionConflictDescription(Workspace workspace, Conflict conflict, ItemSpec[] conflictItemSpecs) {
        super(workspace, conflict, conflictItemSpecs);
    }

    @Override
    public ConflictCategory getConflictCategory() {
        return ConflictCategory.VERSION;
    }

    @Override
    public String getName() {
        return Messages.getString("VersionConflictDescription.Name");
    }

    @Override
    public String getDescription() {
        if (this.filesRenamed() && this.isEncodingChange()) {
            return Messages.getString("VersionConflictDescription.DescriptionRenamedAndEncodingChange");
        }
        if (this.filesRenamedOnly()) {
            return Messages.getString("VersionConflictDescription.DescriptionRenamedOnly");
        }
        if (this.filesRenamed()) {
            return Messages.getString("VersionConflictDescription.DescriptionRenamed");
        }
        if (this.isEncodingChange()) {
            return Messages.getString("VersionConflictDescription.EncodingChanged");
        }
        return Messages.getString("VersionConflictDescription.DescriptionChanged");
    }

    @Override
    public boolean showChangeDescription() {
        return true;
    }

    @Override
    public boolean analyzeConflict() {
        if (this.getConflict().getBaseItemType() == ItemType.FILE || this.getConflict().getYourItemType() == ItemType.FILE || this.getConflict().getTheirItemType() == ItemType.FILE) {
            Workspace workspace = this.getWorkspace();
            MergeEngine mergeEngine = new MergeEngine(workspace, workspace.getClient());
            mergeEngine.countContentConflicts(this.getConflict());
        }
        this.hasAnalyzed = true;
        return true;
    }

    @Override
    public boolean hasAnalyzed() {
        return this.hasAnalyzed;
    }

    @Override
    public void clearAnalysis() {
        this.hasAnalyzed = false;
    }

    protected boolean filesRenamed() {
        Conflict conflict = this.getConflict();
        if (conflict != null) {
            return conflict.getBaseServerItem() == null || !conflict.getBaseServerItem().equals(conflict.getTheirServerItem());
        }
        return false;
    }

    protected boolean filesRenamedOnly() {
        Conflict conflict = this.getConflict();
        if (conflict != null) {
            return conflict.getYourChangeType().equals(ChangeType.RENAME) && conflict.getTheirChangeType().equals(ChangeType.RENAME);
        }
        return false;
    }

    private boolean filesBinary() {
        Conflict conflict = this.getConflict();
        return conflict.getBaseEncoding() == FileEncoding.BINARY || conflict.getTheirEncoding() == FileEncoding.BINARY || conflict.getYourEncoding() == FileEncoding.BINARY;
    }

    protected boolean isEncodingChange() {
        Conflict conflict = this.getConflict();
        if (conflict != null && !conflict.getBaseChangeType().containsAll(ChangeType.ROLLBACK.combine(ChangeType.DELETE))) {
            if (!conflict.getTheirEncoding().equals(conflict.getYourEncoding())) {
                return true;
            }
            if (conflict.getBaseEncoding() != null && conflict.getBaseEncoding().getCodePage() > 0 && !conflict.getTheirEncoding().equals(conflict.getBaseEncoding())) {
                return true;
            }
        }
        return false;
    }

    private boolean isAutomergeEnabled() {
        MergeSummary mergeSummary;
        Conflict conflict = this.getConflict();
        if (this.filesBinary()) {
            return false;
        }
        if (this.filesRenamedOnly()) {
            return true;
        }
        if (this.isBaseless()) {
            return false;
        }
        if (this.hasAnalyzed && (mergeSummary = conflict.getContentMergeSummary()) != null) {
            return mergeSummary.getTotalConflictingLines() == 0;
        }
        return !this.hasAnalyzed;
    }

    protected boolean targetRenamed() {
        return false;
    }

    @Override
    public String getChangeDescription() {
        MergeSummary mergeSummary;
        Conflict conflict = this.getConflict();
        String changeDescription = this.filesBinary() ? ConflictDescriptionStrings.SUMMARY_BINARY : (this.filesRenamedOnly() ? ConflictDescriptionStrings.SUMMARY_RENAMED : (this.hasAnalyzed && (mergeSummary = conflict.getContentMergeSummary()) != null ? (mergeSummary.getTotalConflictingLines() > 0 ? MessageFormat.format(ConflictDescriptionStrings.SUMMARY_CONTENT_CONFLICT, this.getLocalFileDescription(), this.getRemoteFileDescription()) : (this.isEncodingChange() ? ConflictDescriptionStrings.SUMMARY_CONTENT_AND_ENCODING_CHANGED : (this.isBaseless() ? ConflictDescriptionStrings.BASELESS_MERGE_CONFLICT : MessageFormat.format(ConflictDescriptionStrings.SUMMARY_BOTH_CHANGED, this.getLocalFileDescription(), this.getRemoteFileDescription())))) : (this.hasAnalyzed && this.targetRenamed() ? ConflictDescriptionStrings.SUMMARY_NO_MERGE_AVAILABLE : (this.hasAnalyzed ? ConflictDescriptionStrings.SUMMARY_UNMERGEABLE : Messages.getString("VersionConflictDescription.ChangeDescription")))));
        return changeDescription;
    }

    @Override
    public ConflictResolution[] getResolutions(ConflictResolutionContributor conflictResolutionContributor) {
        ArrayList<ConflictResolution> resolutionList = new ArrayList<ConflictResolution>();
        Conflict conflict = this.getConflict();
        ConflictResolutionOptions resolutionOptions = ConflictResolutionOptions.NONE;
        if (this.filesRenamed() && this.isEncodingChange()) {
            resolutionOptions = ConflictResolutionOptions.SELECT_NAME.combine(ConflictResolutionOptions.SELECT_ENCODING);
            resolutionList.add(new CoreConflictResolution(this, ConflictDescriptionStrings.RENAME_ENCODING_AND_AUTOMERGE, ConflictDescriptionStrings.RENAME_ENCODING_AND_AUTOMERGE_TOOLTIP, resolutionOptions, Resolution.ACCEPT_MERGE));
        } else if (this.filesRenamedOnly()) {
            resolutionList.add(new CoreConflictResolution(this, ConflictDescriptionStrings.RENAME, ConflictDescriptionStrings.RENAME_TOOLTIP, ConflictResolutionOptions.SELECT_NAME, Resolution.ACCEPT_MERGE));
        } else if (this.filesRenamed()) {
            resolutionList.add(new CoreConflictResolution(this, ConflictDescriptionStrings.RENAME_AND_AUTOMERGE, ConflictDescriptionStrings.RENAME_AND_AUTOMERGE_TOOLTIP, ConflictResolutionOptions.SELECT_NAME, Resolution.ACCEPT_MERGE));
            resolutionOptions = ConflictResolutionOptions.SELECT_NAME;
        } else if (this.isEncodingChange()) {
            resolutionList.add(new CoreConflictResolution(this, MessageFormat.format(ConflictDescriptionStrings.SELECT_ENCODING_AND_AUTOMERGE, this.getLocalFileDescription(), this.getRemoteFileDescription()), ConflictDescriptionStrings.SELECT_ENCODING_AND_AUTOMERGE_TOOLTIP, ConflictResolutionOptions.SELECT_ENCODING, Resolution.ACCEPT_MERGE));
            resolutionOptions = ConflictResolutionOptions.SELECT_ENCODING;
        } else if (conflict != null && !conflict.getBaseChangeType().containsAll(ChangeType.ROLLBACK.combine(ChangeType.DELETE))) {
            resolutionList.add(new CoreConflictResolution(this, ConflictDescriptionStrings.AUTOMERGE, MessageFormat.format(ConflictDescriptionStrings.AUTOMERGE_TOOLTIP, this.getLocalFileDescription(), this.getRemoteFileDescription()), ConflictResolutionOptions.NONE, Resolution.ACCEPT_MERGE));
        }
        if (!this.filesRenamedOnly() && conflictResolutionContributor != null) {
            resolutionList.addAll(this.loadContributedResolutions(conflictResolutionContributor, resolutionOptions));
        }
        resolutionList.add(new CoreConflictResolution(this, ConflictDescriptionStrings.VERSION_ACCEPT_THEIRS, ConflictDescriptionStrings.VERSION_ACCEPT_THEIRS_TOOLTIP, ConflictResolutionOptions.NONE, Resolution.ACCEPT_THEIRS));
        resolutionList.add(new CoreConflictResolution(this, ConflictDescriptionStrings.VERSION_ACCEPT_YOURS, ConflictDescriptionStrings.VERSION_ACCEPT_YOURS_TOOLTIP, ConflictResolutionOptions.NONE, Resolution.ACCEPT_YOURS));
        return resolutionList.toArray(new ConflictResolution[resolutionList.size()]);
    }

    @Override
    public boolean isResolutionEnabled(ConflictResolution resolution) {
        Check.notNull(resolution, "resolution");
        if (this.getConflict() == null) {
            return true;
        }
        if (resolution instanceof CoreConflictResolution && ((CoreConflictResolution)resolution).getResolution() == Resolution.ACCEPT_MERGE) {
            if (this.getConflict().getBaseItemType() == ItemType.FOLDER && this.getConflict().getYourItemType() == ItemType.FOLDER && this.getConflict().getTheirItemType() == ItemType.FOLDER) {
                return true;
            }
            return this.isAutomergeEnabled();
        }
        return true;
    }
}

