/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.GetOptions;
import com.microsoft.tfs.core.clients.versioncontrol.PendChangesOptions;
import com.microsoft.tfs.core.clients.versioncontrol.UpdateLocalVersionQueue;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolution;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolutionOptions;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolutionStatus;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.CoreConflictResolution;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.LockLevel;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Resolution;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.exceptions.TECoreException;
import com.microsoft.tfs.core.util.FileEncoding;

public class KeepLocalWritableConflictResolution
extends CoreConflictResolution {
    public KeepLocalWritableConflictResolution(ConflictDescription conflictDescription, String description, String helpText) {
        super(conflictDescription, description, helpText, ConflictResolutionOptions.NONE, Resolution.DELETE_CONFLICT);
    }

    @Override
    public ConflictResolution newForConflictDescription(ConflictDescription conflictDescription) {
        return new KeepLocalWritableConflictResolution(conflictDescription, this.getDescription(), this.getHelpText());
    }

    @Override
    public void setNewPath(String newPath) {
        throw new TECoreException(Messages.getString("KeepLocalWritableConflictResolution.CannotAcceptNewPath"));
    }

    @Override
    public void setEncoding(FileEncoding newEncoding) {
        throw new TECoreException(Messages.getString("KeepLocalWritableConflictResolution.CannotAcceptNewEncoding"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConflictResolutionStatus work() {
        ConflictResolutionStatus status = super.work();
        if (!ConflictResolutionStatus.SUCCESS.equals(status)) {
            return status;
        }
        ConflictDescription conflictDescription = this.getConflictDescription();
        Workspace workspace = conflictDescription.getWorkspace();
        UpdateLocalVersionQueue ulvq = new UpdateLocalVersionQueue(workspace);
        try {
            ulvq.queueUpdate(conflictDescription.getConflict().getTheirServerItem(), conflictDescription.getConflict().getTheirItemID(), conflictDescription.getConflict().getTargetLocalItem(), conflictDescription.getConflict().getTheirVersion(), null);
        }
        finally {
            ulvq.close();
        }
        if (workspace.pendEdit(new String[]{conflictDescription.getConflict().getTheirServerItem()}, RecursionType.NONE, LockLevel.UNCHANGED, null, GetOptions.NONE, PendChangesOptions.NONE) != 1) {
            return ConflictResolutionStatus.FAILED;
        }
        return ConflictResolutionStatus.SUCCESS;
    }
}

