/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.BaselineUpdaterAsyncOperation;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers.Worker;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers.WorkerStatus;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BaselineRequest;
import com.microsoft.tfs.core.clients.versioncontrol.localworkspace.BaselineFolder;
import com.microsoft.tfs.jni.FileSystemAttributes;
import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.FileHelpers;
import com.microsoft.tfs.util.IOUtils;
import com.microsoft.tfs.util.tasks.TaskMonitor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaselineUpdaterWorker
implements Worker {
    private static final Log log = LogFactory.getLog(BaselineUpdaterWorker.class);
    private final TaskMonitor monitor;
    private final BaselineRequest request;
    private final BaselineUpdaterAsyncOperation state;

    public BaselineUpdaterWorker(TaskMonitor monitor, BaselineRequest baselineRequest, BaselineUpdaterAsyncOperation state) {
        Check.notNull(monitor, "monitor");
        Check.notNull(baselineRequest, "baselineRequest");
        Check.notNull(state, "state");
        this.monitor = monitor;
        this.request = baselineRequest;
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkerStatus call() throws Exception {
        block21: {
            try {
                boolean completedSuccessfully = false;
                int token = this.state.getBaselineFolderCollection().lockForRead();
                try {
                    InputStream inputStream;
                    String baselineFilePath = this.state.getBaselineFolderCollection().getNewBaselineLocation(this.request.getBaselineFileGUID(), this.request.getBaselinePartitionLocalItem(), token);
                    File fi = new File(baselineFilePath);
                    long uncompressedFileSize = fi.length();
                    this.monitor.setCurrentWorkDescription(MessageFormat.format(Messages.getString("BaselineUpdaterWorker.UpdatingBaselineFormat"), baselineFilePath));
                    baselineFilePath = baselineFilePath + BaselineFolder.getGzipExtension();
                    if (uncompressedFileSize >= 0xFFFFFFFFL) break block21;
                    byte[] buffer = new byte[4096];
                    byte[] hashValue = null;
                    MessageDigest md5Digest = null;
                    if (this.request.getHashValue() != null) {
                        md5Digest = MessageDigest.getInstance("MD5");
                    }
                    GZIPOutputStream outputStream = new GZIPOutputStream(new FileOutputStream(baselineFilePath));
                    String sourceLocalItem = this.request.getSourceLocalItem();
                    FileSystemUtils util = FileSystemUtils.getInstance();
                    FileSystemAttributes attrs = util.getAttributes(sourceLocalItem);
                    if (attrs.isSymbolicLink()) {
                        String linkTarget = util.getSymbolicLink(sourceLocalItem);
                        inputStream = new ByteArrayInputStream(linkTarget.getBytes("UTF-8"));
                    } else {
                        inputStream = new FileInputStream(this.request.getSourceLocalItem());
                    }
                    try {
                        int bytesRead;
                        while ((bytesRead = ((InputStream)inputStream).read(buffer, 0, buffer.length)) > 0) {
                            if (null != md5Digest) {
                                md5Digest.update(buffer, 0, bytesRead);
                            }
                            outputStream.write(buffer, 0, bytesRead);
                        }
                        if (null != md5Digest) {
                            hashValue = md5Digest.digest();
                        }
                    }
                    finally {
                        if (outputStream != null) {
                            IOUtils.closeSafely(outputStream);
                        }
                        if (inputStream != null) {
                            IOUtils.closeSafely(inputStream);
                        }
                    }
                    if (null != hashValue && 16 == hashValue.length && null != this.request.getHashValue() && 16 == this.request.getHashValue().length && !Arrays.equals(this.request.getHashValue(), hashValue)) {
                        FileHelpers.deleteFileWithoutException(baselineFilePath);
                    } else {
                        completedSuccessfully = true;
                    }
                }
                catch (Exception ex) {
                    log.trace((Object)"BaselineUpdater", (Throwable)ex);
                }
                finally {
                    this.state.getBaselineFolderCollection().unlockForRead(token);
                    if (!completedSuccessfully) {
                        this.state.addFailedRequest(this.request);
                    }
                }
            }
            catch (Throwable t) {
                this.state.setFatalError(t);
                return new WorkerStatus(this, WorkerStatus.FinalState.ERROR);
            }
        }
        return new WorkerStatus(this, WorkerStatus.FinalState.NORMAL);
    }
}

