/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.ClientLocalVersionUpdate;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceLocation;
import com.microsoft.tfs.core.clients.versioncontrol.WorkspaceOptions;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.AsyncGetOperation;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.BaselineFileDownloadOutput;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.FileDownloadOutput;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.GetEngine;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers.AbstractDownloadWorker;
import com.microsoft.tfs.core.clients.versioncontrol.engines.internal.workers.WorkerStatus;
import com.microsoft.tfs.core.clients.versioncontrol.events.EventSource;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.internal.localworkspace.BaselineFolderCollection;
import com.microsoft.tfs.core.clients.versioncontrol.path.LocalPath;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ChangeType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.GetOperation;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.specs.DownloadOutput;
import com.microsoft.tfs.jni.FileSystemAttributes;
import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.datetime.DotNETDate;
import com.microsoft.tfs.util.tasks.CanceledException;
import com.microsoft.tfs.util.tasks.TaskMonitor;
import com.microsoft.tfs.util.temp.TempStorageService;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetDownloadWorker
extends AbstractDownloadWorker {
    private static final Log log = LogFactory.getLog(GetDownloadWorker.class);
    private final GetEngine getEngine;
    private final GetOperation operation;
    private final AsyncGetOperation asyncOp;
    private final FileSystemAttributes existingLocalAttrs;
    private final BaselineFolderCollection baselineFolders;
    private final byte[] baselineFileGUID;

    public GetDownloadWorker(EventSource eventSource, TaskMonitor cancelMonitor, VersionControlClient client, GetEngine getEngine, GetOperation operation, AsyncGetOperation asyncOp, FileSystemAttributes existingLocalAttrs, BaselineFolderCollection baselineFolders, byte[] baselineFileGUID) {
        super(eventSource, cancelMonitor, client);
        Check.notNull(getEngine, "getEngine");
        Check.notNull(operation, "operation");
        Check.notNull(asyncOp, "asyncOp");
        Check.notNull(existingLocalAttrs, "existingLocalAttrs");
        this.getEngine = getEngine;
        this.operation = operation;
        this.asyncOp = asyncOp;
        this.existingLocalAttrs = existingLocalAttrs;
        this.baselineFolders = baselineFolders;
        this.baselineFileGUID = baselineFileGUID;
    }

    @Override
    public WorkerStatus call() throws Exception {
        try {
            if (this.getCancelMonitor().isCanceled()) {
                return new WorkerStatus(this, WorkerStatus.FinalState.CANCELED);
            }
            AtomicBoolean targetSymLink = new AtomicBoolean();
            AtomicBoolean targetSymLinkDestinationUnmapped = new AtomicBoolean();
            this.downloadFile(targetSymLink, targetSymLinkDestinationUnmapped);
            this.completeGetOperation(targetSymLink.get(), targetSymLinkDestinationUnmapped.get());
        }
        catch (VersionControlException e) {
            log.warn((Object)"Converted to non-fatal", (Throwable)e);
            this.getEngine.onNonFatalError(new VersionControlException(MessageFormat.format(Messages.getString("GetEngineDownloadWorker.AColonBFormat"), this.operation.getTargetLocalItem(), e.getLocalizedMessage()), e), this.asyncOp.getWorkspace());
        }
        catch (CanceledException e) {
            return new WorkerStatus(this, WorkerStatus.FinalState.CANCELED);
        }
        catch (Throwable t) {
            this.asyncOp.setFatalError(t);
            return new WorkerStatus(this, WorkerStatus.FinalState.ERROR);
        }
        return new WorkerStatus(this, WorkerStatus.FinalState.NORMAL);
    }

    protected void downloadFile(AtomicBoolean targetSymLink, AtomicBoolean targetSymLinkDestinationUnmapped) throws CanceledException {
        int readLockToken = 0;
        boolean updateBaseline = this.baselineFolders != null && this.baselineFileGUID != null;
        File baselineTempFile = null;
        File workingFolderTempFile = null;
        ArrayList<DownloadOutput> outputs = new ArrayList<DownloadOutput>(2);
        try {
            BaselineFileDownloadOutput baselineOutput = null;
            if (updateBaseline) {
                readLockToken = this.baselineFolders.lockForRead();
                String baselineFileNoSuffix = this.baselineFolders.getNewBaselineLocation(this.baselineFileGUID, this.operation.getTargetLocalItem(), readLockToken);
                baselineOutput = new BaselineFileDownloadOutput(new File(baselineFileNoSuffix), false);
                outputs.add(baselineOutput);
            }
            FileDownloadOutput workingFolderOutput = null;
            File targetLocalItemDirectory = new File(this.operation.getTargetLocalItem()).getParentFile();
            if (targetLocalItemDirectory.exists() && !targetLocalItemDirectory.isDirectory()) {
                throw new VersionControlException(MessageFormat.format(Messages.getString("GetEngineDownloadWorker.CannotCreateDirectoryBecauseFileAlreadyExistsFormat"), targetLocalItemDirectory));
            }
            if (!(targetLocalItemDirectory.exists() || targetLocalItemDirectory.mkdirs() || targetLocalItemDirectory.isDirectory())) {
                throw new VersionControlException(MessageFormat.format(Messages.getString("GetEngineDownloadWorker.CannotCreateDirectoryBecauseFileAlreadyExistsFormat"), targetLocalItemDirectory));
            }
            try {
                workingFolderTempFile = File.createTempFile("teamexplorer", ".tmp", targetLocalItemDirectory);
                log.trace((Object)MessageFormat.format("Using temp file {0} for download", workingFolderTempFile));
            }
            catch (IOException e) {
                throw new VersionControlException(MessageFormat.format(Messages.getString("GetEngineDownloadWorker.CouldNotCreateTemporaryFileInDirectoryFormat"), targetLocalItemDirectory, e.getLocalizedMessage()), e);
            }
            workingFolderOutput = new FileDownloadOutput(workingFolderTempFile, true);
            outputs.add(workingFolderOutput);
            this.getClient().downloadFileToStreams(this.operation.createDownloadSpec(), outputs.toArray(new DownloadOutput[outputs.size()]), this.getEventSource(), this.getCancelMonitor());
            if (baselineOutput != null) {
                baselineTempFile = baselineOutput.isTempFileCreatedInsteadOfBaseline() ? baselineOutput.getOutputStreamFile() : null;
            }
            this.closeDownloadOutputStreamsSafely(outputs);
            this.moveTempFileToTargetFile(workingFolderTempFile, targetSymLink, targetSymLinkDestinationUnmapped);
            workingFolderTempFile = null;
        }
        catch (CanceledException e) {
            throw e;
        }
        finally {
            if (updateBaseline && readLockToken != 0) {
                this.baselineFolders.unlockForRead(readLockToken);
            }
            this.closeDownloadOutputStreamsSafely(outputs);
            if (baselineTempFile != null) {
                baselineTempFile.delete();
            }
            if (workingFolderTempFile != null) {
                workingFolderTempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTempFileToTargetFile(File tempFile, AtomicBoolean targetSymLink, AtomicBoolean targetSymLinkDestinationUnmapped) {
        Check.notNull(tempFile, "tempFile");
        if (!tempFile.exists()) {
            throw new VersionControlException(MessageFormat.format(Messages.getString("GetEngineDownloadWorker.TempFileIsMissingCantCompleteTheDownloadFormat"), tempFile));
        }
        String targetSymLinkDestination = this.getEngine.getSymbolicLinkDestination(tempFile, this.operation, this.asyncOp.getWorkspace());
        File targetFile = new File(this.operation.getTargetLocalItem());
        try {
            FileSystemAttributes originalTargetAttrs;
            if (targetSymLinkDestination == null) {
                this.getEngine.applyFileAttributesToTempFile(this.operation.getTargetServerItem(), this.operation.getTargetLocalItem(), this.operation.getEncoding(), tempFile, this.operation);
            }
            if ((originalTargetAttrs = FileSystemUtils.getInstance().getAttributes(targetFile)).exists()) {
                log.trace((Object)MessageFormat.format("target file {0} exists, deleting", targetFile));
                if (targetSymLinkDestination == null && originalTargetAttrs.isReadOnly()) {
                    log.trace((Object)MessageFormat.format("setting target file {0} writable before delete", targetFile));
                    originalTargetAttrs.setReadOnly(false);
                    if (FileSystemUtils.getInstance().setAttributes(targetFile, originalTargetAttrs)) {
                        log.trace((Object)MessageFormat.format("target file {0} now writable before delete", targetFile));
                    } else {
                        log.warn((Object)MessageFormat.format("error setting file {0} writable before delete, expect trouble finishing the get", targetFile));
                    }
                }
                if (!targetFile.delete()) {
                    tempFile.delete();
                    throw new VersionControlException(MessageFormat.format(Messages.getString("GetEngineDownloadWorker.DeleteOfTargetFileFailedMakeSureNotInUseFormat"), targetFile));
                }
            }
            if (targetSymLink != null) {
                targetSymLink.set(false);
            }
            if (targetSymLinkDestinationUnmapped != null) {
                targetSymLinkDestinationUnmapped.set(false);
            }
            if (targetSymLinkDestination != null) {
                if (targetSymLink != null) {
                    targetSymLink.set(true);
                }
                log.trace((Object)MessageFormat.format("target {0} should be a symbolic link", this.operation.getTargetLocalItem()));
                if (targetSymLinkDestination.length() > 0) {
                    log.trace((Object)MessageFormat.format("creating link to mapped path {0}", targetSymLinkDestination));
                    FileSystemUtils.getInstance().createSymbolicLink(targetSymLinkDestination, this.operation.getTargetLocalItem());
                } else {
                    if (targetSymLinkDestinationUnmapped != null) {
                        targetSymLinkDestinationUnmapped.set(true);
                    }
                    log.info((Object)MessageFormat.format("Symbolic link at {0} would point to unmapped item, not creating link", this.operation.getTargetLocalItem()));
                }
                TempStorageService.getInstance().deleteItem(tempFile);
                log.trace((Object)MessageFormat.format("link at {0} created", this.operation.getTargetLocalItem()));
            } else {
                log.trace((Object)MessageFormat.format("renaming temp file {0} to target {1}", tempFile, this.operation.getTargetLocalItem()));
                TempStorageService.getInstance().renameItem(tempFile, targetFile);
            }
        }
        finally {
            if (tempFile.exists()) {
                TempStorageService.getInstance().deleteItem(tempFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeGetOperation(boolean targetSymLink, boolean targetSymLinkDestinationUnmapped) {
        Check.notNullOrEmpty(this.operation.getTargetLocalItem(), "operation.getTargetLocalItem()");
        log.trace((Object)MessageFormat.format("completing get operation for {0} ({1})", this.operation.getTargetLocalItem(), this.operation.getTargetServerItem()));
        GetOperation getOperation = this.operation;
        synchronized (getOperation) {
            if (!(targetSymLink || this.operation.getEffectiveChangeType().contains(ChangeType.EDIT) && !this.operation.isUndo())) {
                File targetLocalFile = new File(this.operation.getTargetLocalItem());
                FileSystemAttributes attrs = FileSystemUtils.getInstance().getAttributes(targetLocalFile);
                if (0 != this.operation.getVersionServer() && !DotNETDate.MIN_CALENDAR.equals(this.operation.getVersionServerDate()) && this.asyncOp.getWorkspace().getOptions().contains(WorkspaceOptions.SET_FILE_TO_CHECKIN)) {
                    if (attrs.isReadOnly()) {
                        attrs.setReadOnly(false);
                        FileSystemUtils.getInstance().setAttributes(targetLocalFile, attrs);
                    }
                    targetLocalFile.setLastModified(this.operation.getVersionServerDate().getTimeInMillis());
                }
                if (WorkspaceLocation.SERVER == this.asyncOp.getWorkspace().getLocation() && !attrs.isReadOnly()) {
                    attrs.setReadOnly(true);
                    FileSystemUtils.getInstance().setAttributes(targetLocalFile, attrs);
                }
            }
            if (!targetSymLinkDestinationUnmapped) {
                byte[] hashValue = null;
                long committedLength = -1L;
                if (null != this.operation.getBaselineFileGUID()) {
                    Check.isTrue(!this.operation.getEffectiveChangeType().contains(ChangeType.EDIT), "operation.getEffectiveChangeType().contains(ChangeType.EDIT) == false");
                    hashValue = this.operation.getHashValue();
                    committedLength = new File(this.operation.getTargetLocalItem()).length();
                }
                String pendingChangeTargetServerItem = this.operation.getTargetServerItem();
                if (this.operation.getChangeType().equals(ChangeType.NONE) || this.operation.getChangeType().contains(ChangeType.ADD)) {
                    pendingChangeTargetServerItem = null;
                }
                ClientLocalVersionUpdate update = new ClientLocalVersionUpdate(this.operation.getSourceServerItem(), this.operation.getItemID(), this.operation.getTargetLocalItem(), this.operation.getVersionServer(), this.operation.getVersionServerDate(), this.operation.getEncoding(), hashValue, committedLength, this.operation.getBaselineFileGUID(), pendingChangeTargetServerItem, this.operation.getPropertyValues());
                this.asyncOp.queueLocalVersionUpdate(update);
            }
            if (this.existingLocalAttrs.exists() && this.operation.getCurrentLocalItem() != null && !LocalPath.equals(this.operation.getCurrentLocalItem(), this.operation.getTargetLocalItem())) {
                Check.isTrue(this.operation.getItemType() != ItemType.FOLDER, "Should not try to delete a folder here: " + this.operation);
                log.trace((Object)MessageFormat.format("deleting source {0}", this.operation.getCurrentLocalItem()));
                this.getEngine.deleteSource(this.operation, this.existingLocalAttrs);
            }
            this.getEngine.applyFileAttributesAfterGet(this.asyncOp, this.operation);
            this.operation.setDownloadCompleted(true);
        }
    }
}

